/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.sources;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileContributorProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.impl.SourceFileByte;
import com.nxp.swtools.provider.configuration.sources.impl.SourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.impl.SourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.impl.SourceFileString;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class SourceFileProviderFactory {
    private static final String EXTENSION_NAME = "com.nxp.swtools.sharedconfiguration.generation";
    private static final String PROVIDER_ELEMENT_NAME = "sourceProvider";
    private static final String EXTERNAL_PROVIDER_ELEMENT_NAME = "externalSourceProvider";
    public static final List<String> SUPPORTED_FILE_EXTENSION_FOR_CUSTOM_COPYRIGHT = CollectionsUtils.unmodifiableList(Arrays.asList(".c", ".h", ".dts", ".dtsi"));
    static final Logger LOGGER = LogManager.getLogger(SourceFileProviderFactory.class);

    private SourceFileProviderFactory() {
    }

    public static Collection<ISourceFileProvider> getSourceFileProviders() {
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(EXTENSION_NAME, PROVIDER_ELEMENT_NAME, "class");
        return extensionProvider.getExtensions();
    }

    public static @Nullable ISourceFileProviderWrapper getSourceFileProvidersWrapper(String toolId) {
        Collection<ISourceFileProvider> sourceProviders = SourceFileProviderFactory.getSourceFileProviders(toolId);
        Collection<ISourceFileContributorProvider> externalSourceProviders = SourceFileProviderFactory.getDerivedSourceFileProviders(toolId);
        if (sourceProviders.isEmpty() && externalSourceProviders.isEmpty()) {
            return null;
        }
        return new SourceFileProviderWrapper(sourceProviders, externalSourceProviders);
    }

    public static Collection<ISourceFileProvider> getSourceFileProviders(String toolId) {
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(EXTENSION_NAME, PROVIDER_ELEMENT_NAME, "class", toolId::equals, "tool_id", null);
        return extensionProvider.getExtensions();
    }

    public static Collection<ISourceFileContributorProvider> getDerivedSourceFileProviders(String toolId) {
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(EXTENSION_NAME, EXTERNAL_PROVIDER_ELEMENT_NAME, "class", toolId::equals, "tool_id", null);
        return extensionProvider.getExtensions();
    }

    public static Collection<@NonNull ISourceFile> buildSourceFileList(@Nullable Map<String, String> generatedFiles, @Nullable Map<String, byte[]> generatedBinaryFiles, @Nullable ICustomCopyrightHeaderRead customCopyright) {
        ArrayList<ISourceFile> result = new ArrayList<ISourceFile>();
        if (generatedFiles != null) {
            for (Map.Entry<String, String> entry : generatedFiles.entrySet()) {
                result.add(SourceFileProviderFactory.createSourceFileFromString(entry.getKey(), entry.getValue(), customCopyright));
            }
        }
        if (generatedBinaryFiles != null) {
            for (Map.Entry<String, String> entry : generatedBinaryFiles.entrySet()) {
                result.add(SourceFileProviderFactory.createSourceFileFromBytes(entry.getKey(), (byte[])entry.getValue(), true));
            }
        }
        return result;
    }

    public static Collection<ISourceFile> buildSourceFileList(Map<String, String> generatedFiles, @Nullable ICustomCopyrightHeaderRead customCopyright) {
        return SourceFileProviderFactory.buildSourceFileList(generatedFiles, null, customCopyright);
    }

    @Deprecated
    public static ISourceFile createSourceFileFromString(String relFilePath, String content) {
        LOGGER.warning("Calling deprecated createSourceFileFromString without ICustomCopyrightHeaderRead parameter");
        return SourceFileProviderFactory.createSourceFileFromString(relFilePath, content, null);
    }

    public static ISourceFile createSourceFileFromString(String relFilePath, String content, @Nullable ICustomCopyrightHeaderRead customCopyright) {
        return new SourceFileString(relFilePath, false, SourceFileProviderFactory.insertCustomFileHeaderToSourceFile(relFilePath, content, customCopyright));
    }

    public static String insertCustomFileHeaderToSourceFile(String filePath, String content, @Nullable ICustomCopyrightHeaderRead copyright) {
        if (copyright != null && copyright.isEnabled() && !UtilsText.isEmpty((String)copyright.getText()) && SUPPORTED_FILE_EXTENSION_FOR_CUSTOM_COPYRIGHT.contains(UtilsFile.getFileExtensionWithDotWithoutCoreId((String)filePath).toLowerCase()) && !SourceFileProviderFactory.isCopyrightPresent(content)) {
            String customCopyrigth = SourceFileProviderFactory.ensureTextWrapedByBlockComment(copyright.getText());
            return String.valueOf(customCopyrigth) + content;
        }
        return content;
    }

    public static String ensureTextWrapedByBlockComment(String text) {
        if (UtilsText.getCBlockComments((String)text).isEmpty()) {
            text = UtilsText.cBlockComment((String)text);
        }
        return String.valueOf(text) + "\n";
    }

    public static boolean isCopyrightPresent(String content) {
        List comments = UtilsText.getCBlockComments((String)content);
        return !comments.isEmpty() && ((String)CollectionsUtils.first((Collection)comments)).toLowerCase().contains(" copyright ");
    }

    public static ISourceFile createSourceFileFromBytes(String relFileName, byte[] content, boolean binary) {
        return new SourceFileByte(relFileName, binary, content);
    }

    public static Stream<String> getGeneratedRelFileNames(Collection<ISourceFile> generatedFiles) {
        return generatedFiles.stream().map(ISourceFile::getRelFileName);
    }

    public static Stream<Path> getGeneratedRelFilePaths(Collection<ISourceFile> generatedFiles) {
        return generatedFiles.stream().map(ISourceFile::getRelFilePath);
    }

    public static ISourceFileGenerationStatus buildGenerationStatus(ISourceFileGenerationStatus.GenerationStatus status, String message) {
        return new SourceFileGenerationStatus(status, message);
    }

    public static ISourceFileGenerationStatus buildGenerationOKStatus() {
        return SourceFileGenerationStatus.OK_STATUS;
    }
}

