/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.sources;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.sources.SimpleDestinationPathProvider;
import com.nxp.swtools.provider.configuration.storage.OutputPathOverrideRule;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OverriddenDestinationPathProvider
extends SimpleDestinationPathProvider {
    Logger LOGGER = LogManager.getLogger(OverriddenDestinationPathProvider.class);
    private List<Path> overridenPath = new ArrayList<Path>();
    @Nullable
    private List<OutputPathOverrideRule> rules;

    public OverriddenDestinationPathProvider(Path targetPath, @Nullable List<OutputPathOverrideRule> overrideRules) {
        super(targetPath);
        this.rules = overrideRules;
    }

    @Override
    public Path getDestinationPath(String relFilePath) {
        Path path = super.getDestinationPath(relFilePath);
        List<OutputPathOverrideRule> lRules = this.rules;
        if (lRules != null) {
            String stringPath = UtilsFile.toEclipsePath((String)path.toString());
            for (OutputPathOverrideRule rule : lRules) {
                Pattern pat;
                Matcher match;
                if (!rule.isEnabled() || !(match = (pat = Pattern.compile(rule.getRegex())).matcher(stringPath)).find()) continue;
                stringPath = match.replaceAll(rule.getReplacement());
            }
            if (UtilsFile.isFilePathValid((String)stringPath)) {
                Path newPath = Paths.get(stringPath, new String[0]);
                if (!path.equals(newPath)) {
                    path = newPath;
                    this.overridenPath.add(newPath);
                }
            } else {
                this.LOGGER.log(Level.WARNING, MessageFormat.format("Overriden rules created invalid path {0}, the original {1} will be used", stringPath, UtilsFile.toEclipsePath((String)path.toString())));
            }
        }
        return path;
    }

    public List<Path> getOverridenPath() {
        return this.overridenPath;
    }
}

