/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.Messages;
import java.math.BigInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.ui.progress.WorkbenchJob;

public class MemoryRenderingPropertyChangeListener
implements IPropertyChangeListener {
    private static final String HEX_ADDRESS_FORMAT = "0x%s";
    private static final String MEMORY_LABEL_FORMAT = "%s %s <%s>";
    private final CTabItem tabItem;
    private final String tabDataKey;

    public MemoryRenderingPropertyChangeListener(CTabItem tab, IMemoryRendering rendering, String tabDataKey) {
        this.tabItem = tab;
        this.tabDataKey = tabDataKey;
    }

    public void propertyChange(final PropertyChangeEvent event) {
        if (!(event.getProperty().equals("selectedAddress") || this.tabItem.isDisposed() || this.tabItem.getText().isEmpty())) {
            return;
        }
        WorkbenchJob job = new WorkbenchJob(Messages.MemoryRenderingPropertyChangeListener_job_name){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (MemoryRenderingPropertyChangeListener.this.tabItem.isDisposed() || !(MemoryRenderingPropertyChangeListener.this.tabItem.getData(MemoryRenderingPropertyChangeListener.this.tabDataKey) instanceof MemorySpace)) {
                    return Status.OK_STATUS;
                }
                MemorySpace space = (MemorySpace)MemoryRenderingPropertyChangeListener.this.tabItem.getData(MemoryRenderingPropertyChangeListener.this.tabDataKey);
                BigInteger startAddress = space.getBaseAddress();
                String startAddressTxt = String.format(MemoryRenderingPropertyChangeListener.HEX_ADDRESS_FORMAT, startAddress.toString(16));
                String deltaAddress = String.valueOf(event.getNewValue());
                if (event.getNewValue() instanceof BigInteger) {
                    BigInteger deltaValue = (BigInteger)event.getNewValue();
                    deltaAddress = deltaValue.toString(16);
                }
                String deltaAddressTxt = String.format(MemoryRenderingPropertyChangeListener.HEX_ADDRESS_FORMAT, deltaAddress);
                MemoryRenderingPropertyChangeListener.this.tabItem.setText(String.format(MemoryRenderingPropertyChangeListener.MEMORY_LABEL_FORMAT, space.getName(), startAddressTxt, deltaAddressTxt));
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

