/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.dsf.S32DbgMemoryBlock;
import com.nxp.s32ds.cle.cdt.memory.spaces.dsf.S32DbgMemoryRetrieval;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpaceViewTab;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesUIActivator;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.LaunchListener;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.MemoryBase;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.MemoryRenderingPropertyChangeListener;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.MemorySpaceContentProvider;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.MemorySpaceLabelProvider;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.MemorySpaceRenderingContainer;
import com.nxp.s32ds.cle.cdt.memory.spaces.ui.memento.MemorySpaceContextMemento;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerLaunchUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class MemorySpacesViewer
extends ViewPart
implements IDebugContextListener,
LaunchListener {
    private static final int MINIMUM_LEFT_TAB_WIDTH = 200;
    private static final String HEX_ADDRESS = "0x%s";
    private static final String MEMORY_SPACE = "memory.space";
    private static final String MEMORY_SPACE_RENDERING = "memory.spaces.rendering";
    private static final String MEMORY_SPACE_FLOATING_POINT_RENDERING = "memory.spaces.rendering.floatingpoint";
    private static final String MEMORY_RETRIVAL = "s32ds.memory.spaces.retrivial.";
    private MemorySpaceRenderingContainer container;
    private IAction actAddMemorySpace;
    private TreeViewer memSpacesViewer;
    private CTabFolder memoryAddressFolder;
    private final MemoryBase memoryBase = MemoryBase.getInstance();
    private final List<IMemoryRendering> renderings = new ArrayList<IMemoryRendering>();

    private void updateView() {
        UIJob updateJob = new UIJob("Memory space update job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                GdbLaunch launch = MemorySpacesViewer.this.memoryBase.getMemoryAccessor().getLaunch();
                if (launch != null) {
                    Collection<CTabItem> activeTabs = MemorySpacesViewer.this.memoryBase.getCTabBySession(launch.getSession());
                    Arrays.stream(MemorySpacesViewer.this.memoryAddressFolder.getItems()).filter(tab -> !tab.isDisposed()).forEach(tab -> {
                        if (activeTabs.contains(tab)) {
                            if (!tab.getControl().isEnabled()) {
                                tab.getControl().setEnabled(true);
                                if (MemorySpacesViewer.this.memoryAddressFolder.getSelection() != null && MemorySpacesViewer.this.memoryAddressFolder.getSelection().equals(tab)) {
                                    MemorySpacesViewer.this.updateRendering((CTabItem)tab);
                                }
                            }
                        } else if (tab.getControl().isEnabled()) {
                            tab.getControl().setEnabled(false);
                        }
                    });
                }
                if (!MemorySpacesViewer.this.memSpacesViewer.getControl().isDisposed()) {
                    MemorySpacesViewer.this.memSpacesViewer.setInput(MemorySpacesViewer.this.memoryBase.getMemorySpaces());
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public void setFocus() {
    }

    public void debugContextChanged(DebugContextEvent event) {
        IAdaptable adaptable = MemorySpacesViewer.getAdaptable(event.getContext());
        if (adaptable == null) {
            return;
        }
        this.memoryBase.setEnabledMemorySpacesBySession(false);
        this.memoryBase.getMemoryAccessor().setCurrentContext(adaptable);
        if (this.actAddMemorySpace != null) {
            this.actAddMemorySpace.setEnabled(!this.memoryBase.getMemorySpacesByContext().isEmpty());
        }
        this.memoryBase.setEnabledMemorySpacesBySession(true);
        this.updateView();
    }

    private Viewer createMemoryViewer(Composite parent) {
        GridData fillingData = new GridData(4, 4, true, true, 1, 1);
        SashForm form = new SashForm(parent, 256);
        form.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.memSpacesViewer = new TreeViewer((Composite)form, 2052);
        this.memSpacesViewer.getTree().setLayoutData((Object)fillingData);
        this.memSpacesViewer.getTree().setHeaderVisible(true);
        this.memSpacesViewer.getTree().setLinesVisible(false);
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.memSpacesViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(Messages.MemorySpacesViewer_memory_spaces_column);
        column.setWidth(200);
        this.memSpacesViewer.getTree().addListener(11, event -> {
            int width = this.memSpacesViewer.getTree().getBounds().width - 3;
            if (width != column.getWidth()) {
                if (width >= 200) {
                    column.setWidth(width);
                } else if (column.getWidth() != 200) {
                    column.setWidth(200);
                }
            }
        });
        this.memSpacesViewer.addSelectionChangedListener(selectionEvent -> {
            IStructuredSelection structuredSelection = selectionEvent.getStructuredSelection();
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof MemorySpace) {
                MemorySpace memSpace = (MemorySpace)firstElement;
                CTabItem activeTab = this.memoryBase.getTabByMemorySpace(memSpace).get(0);
                if (activeTab == null) {
                    return;
                }
                if (activeTab.equals(this.memoryAddressFolder.getSelection())) {
                    return;
                }
                this.memoryAddressFolder.setSelection(activeTab);
                if (memSpace.isEnabled()) {
                    this.updateRendering(activeTab);
                }
            }
        });
        this.memSpacesViewer.setContentProvider((IContentProvider)new MemorySpaceContentProvider());
        this.memSpacesViewer.setLabelProvider((IBaseLabelProvider)new MemorySpaceLabelProvider());
        Menu memSpacesMenu = new Menu((Control)this.memSpacesViewer.getTree());
        MenuItem menuItemAdd = new MenuItem(memSpacesMenu, 0);
        menuItemAdd.setText(Messages.MemorySpacesViewer_context_menu_add);
        menuItemAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemorySpacesViewer.this.handleEventAddMemorySpace();
            }
        });
        MenuItem menuItemRemove = new MenuItem(memSpacesMenu, 0);
        menuItemRemove.setText(Messages.MemorySpacesViewer_context_menu_remove);
        menuItemRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemorySpacesViewer.this.handleEventRemoveMemorySpace();
            }
        });
        MenuItem menuItemRemoveAll = new MenuItem(memSpacesMenu, 0);
        menuItemRemoveAll.setText(Messages.MemorySpacesViewer_context_menu_remove_all);
        menuItemRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemorySpacesViewer.this.handleEventRemoveAllMemorySpaces();
            }
        });
        MenuItem menuItemChangeRendering = new MenuItem(memSpacesMenu, 64);
        menuItemChangeRendering.setText(Messages.MemorySpacesViewer_context_menu_add_rendering);
        Menu menuAddRendering = new Menu(menuItemChangeRendering);
        MenuItem menuItemAddHexRendering = new MenuItem(menuAddRendering, 0);
        menuItemAddHexRendering.setText(Messages.MemorySpacesViewer_context_menu_add_rendering_hex_memory_rendering);
        menuItemAddHexRendering.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemorySpacesViewer.this.handleAddHexRendering();
            }
        });
        MenuItem menuItemAddFloatingPointRendering = new MenuItem(menuAddRendering, 0);
        menuItemAddFloatingPointRendering.setText(Messages.MemorySpacesViewer_context_menu_add_rendering_floating_point_memory_rendering);
        menuItemAddFloatingPointRendering.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemorySpacesViewer.this.handleAddFloatingPointRendering();
            }
        });
        menuItemChangeRendering.setMenu(menuAddRendering);
        memSpacesMenu.addListener(22, listener -> {
            TreeItem[] items;
            menuItemAdd.setEnabled(true);
            menuItemRemove.setEnabled(true);
            menuItemRemoveAll.setEnabled(true);
            menuItemChangeRendering.setEnabled(true);
            menuItemAddFloatingPointRendering.setEnabled(true);
            List<DeviceCoreMemorySpaceDescriptor> memorySpaces = this.memoryBase.getMemorySpacesByContext();
            if (memorySpaces == null || memorySpaces.isEmpty()) {
                menuItemAdd.setEnabled(false);
            }
            if (this.memSpacesViewer.getTree().getSelectionCount() == 0) {
                menuItemRemove.setEnabled(false);
                menuItemChangeRendering.setEnabled(false);
            }
            if (this.memoryBase.getMemorySpaces().isEmpty()) {
                menuItemRemoveAll.setEnabled(false);
            }
            if ((items = this.memSpacesViewer.getTree().getSelection()).length > 0 && ((MemorySpace)items[0].getData()).getBytesPerAddress() > 1) {
                menuItemAddFloatingPointRendering.setEnabled(false);
            }
        });
        this.memSpacesViewer.getTree().setMenu(memSpacesMenu);
        this.memoryAddressFolder = new CTabFolder((Composite)form, 2048);
        this.memoryAddressFolder.setLayoutData((Object)fillingData);
        this.memoryAddressFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabItem activeTab = (CTabItem)event.item;
                Object data = activeTab.getData(MemorySpacesViewer.MEMORY_SPACE);
                if (data instanceof MemorySpace) {
                    MemorySpace memorySpace = (MemorySpace)data;
                    if (memorySpace.isEnabled()) {
                        MemorySpacesViewer.this.updateRendering(activeTab);
                    }
                    Arrays.stream(MemorySpacesViewer.this.memSpacesViewer.getTree().getItems()).forEach(item -> {
                        if (item.getData() == memorySpace) {
                            MemorySpacesViewer.this.memSpacesViewer.getTree().setSelection(item);
                        }
                    });
                }
            }
        });
        this.memSpacesViewer.setInput(this.memoryBase.getMemorySpacesBySession());
        form.setWeights(new int[]{1, 3});
        return null;
    }

    private void handleEventRemoveMemorySpace() {
        ITreeSelection selectionItem = this.memSpacesViewer.getStructuredSelection();
        if (selectionItem != null && selectionItem.getFirstElement() instanceof MemorySpace) {
            MemorySpace memorySpace = (MemorySpace)selectionItem.getFirstElement();
            List<CTabItem> tabs = this.memoryBase.getTabByMemorySpace(memorySpace);
            this.memoryBase.removeMemorySpaceForSession(memorySpace);
            for (CTabItem tab : tabs) {
                if (tab == null) continue;
                tab.dispose();
            }
        }
    }

    private void handleAddHexRendering() {
        ITreeSelection selectionItem = this.memSpacesViewer.getStructuredSelection();
        if (selectionItem != null && selectionItem.getFirstElement() instanceof MemorySpace) {
            try {
                MemorySpace memorySpace = (MemorySpace)selectionItem.getFirstElement();
                this.addTabForMemorySpace(memorySpace, this.memoryBase.getMemoryAccessor().getLaunch(), this.getHexRendering());
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void handleAddFloatingPointRendering() {
        ITreeSelection selectionItem = this.memSpacesViewer.getStructuredSelection();
        if (selectionItem != null && selectionItem.getFirstElement() instanceof MemorySpace) {
            try {
                MemorySpace memorySpace = (MemorySpace)selectionItem.getFirstElement();
                this.addTabForMemorySpace(memorySpace, this.memoryBase.getMemoryAccessor().getLaunch(), this.getFloatingPointRendering());
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void handleEventRemoveAllMemorySpaces() {
        Shell activeShell = Display.getDefault().getActiveShell();
        if (!MessageDialog.openQuestion((Shell)activeShell, (String)Messages.MemorySpacesViewer_remove_all_memory_spaces_title, (String)Messages.MemorySpacesViewer_remove_all_memory_spaces_message)) {
            return;
        }
        this.memoryBase.getMemorySpaces().forEach(memorySpace -> {
            List<CTabItem> tabs = this.memoryBase.getTabByMemorySpace((MemorySpace)memorySpace);
            for (CTabItem tab : tabs) {
                if (tab == null) continue;
                this.memoryBase.removeMemorySpace((MemorySpace)memorySpace, tab);
                tab.dispose();
            }
        });
    }

    private void handleEventAddMemorySpace() {
        if (this.actAddMemorySpace != null) {
            this.actAddMemorySpace.run();
        } else {
            Shell activeShell = Display.getDefault().getActiveShell();
            MessageDialog.openWarning((Shell)activeShell, (String)Messages.MemorySpaces_warning_dialog_title, (String)Messages.MemorySpaces_error_no_action);
        }
    }

    private void updateRendering(CTabItem activeTab) {
        IMemoryRendering rendering = (IMemoryRendering)activeTab.getData(this.container.getRenderingTabDataId());
        if (rendering instanceof AbstractBaseTableRendering) {
            Display.getDefault().asyncExec(() -> ((AbstractBaseTableRendering)rendering).refresh());
        }
    }

    public void addTabForMemorySpace(MemorySpace memorySpace, GdbLaunch launch, IMemoryRenderingType renderingType) throws CoreException {
        IMemoryRendering rendering;
        if (renderingType != null) {
            rendering = renderingType.createRendering();
            if (rendering != null) {
                S32DbgMemoryRetrieval retrieval;
                IMemoryBlockExtension block;
                if (launch == null) {
                    launch = this.memoryBase.getMemoryAccessor().getLaunch();
                }
                if ((block = this.createMemoryBlock((IMemoryBlockRetrieval)(retrieval = new S32DbgMemoryRetrieval(MEMORY_RETRIVAL + memorySpace.toModelString(), launch.getLaunchConfiguration(), launch.getSession(), memorySpace.getBytesPerAddress(), memorySpace.getMaxAddress())), memorySpace.getBaseAddress(), this.memoryBase.getMemoryAccessor().getIDMContext(), memorySpace)) == null) {
                    MemorySpacesUIActivator.getInstance().logError(Messages.MemorySpaces_error_memory_block_not_found);
                    return;
                }
                this.container.addMemoryRendering(rendering);
                rendering.init((IMemoryRenderingContainer)this.container, (IMemoryBlock)block);
            }
        } else {
            MemorySpacesUIActivator.getInstance().logError(NLS.bind((String)Messages.MemorySpaces_error_rendering_not_found, (Object)MEMORY_SPACE_RENDERING));
            return;
        }
        Control rightPaneControl = rendering.createControl((Composite)this.memoryAddressFolder);
        rightPaneControl.setLayoutData((Object)new GridData(4, 4, true, true));
        MemorySpaceViewTab tabItem = new MemorySpaceViewTab(this.memoryAddressFolder, 64, rendering);
        tabItem.addDisposeListener(event -> {
            if (!this.memSpacesViewer.getTree().isDisposed() && event.getSource() instanceof CTabItem) {
                CTabItem tab = (CTabItem)event.getSource();
                if (tab.getData(MEMORY_SPACE) instanceof MemorySpace) {
                    MemorySpace space = (MemorySpace)tab.getData(MEMORY_SPACE);
                    if (this.memoryBase.removeTabForMemorySpace(space, tabItem)) {
                        this.memoryBase.removeMemorySpaceForSession(space);
                    }
                    this.updateView();
                }
                this.container.removeMemoryRendering(rendering);
            }
        });
        rendering.getControl().setData((Object)renderingType.getLabel());
        MemoryRenderingPropertyChangeListener listener = new MemoryRenderingPropertyChangeListener(tabItem, rendering, MEMORY_SPACE);
        rendering.addPropertyChangeListener((IPropertyChangeListener)listener);
        tabItem.setControl(rightPaneControl);
        tabItem.setData(MEMORY_SPACE, memorySpace);
        tabItem.setData(this.container.getRenderingTabDataId(), rendering);
        listener.propertyChange(new PropertyChangeEvent((Object)this, "topAddress", (Object)new BigInteger("-1"), (Object)memorySpace.getBaseAddress()));
        this.renderings.add(rendering);
        this.memoryBase.addMemorySpace(memorySpace, tabItem);
        this.memoryAddressFolder.setSelection((CTabItem)tabItem);
        this.memSpacesViewer.setInput(this.memoryBase.getMemorySpaces());
        Arrays.stream(this.memSpacesViewer.getTree().getItems()).forEach(item -> {
            if (item.getData() == memorySpace) {
                this.memSpacesViewer.getTree().setSelection(item);
            }
        });
    }

    public void addTabForMemorySpace(MemorySpace memorySpace, GdbLaunch launch) throws CoreException {
        this.addTabForMemorySpace(memorySpace, launch, this.getHexRendering());
    }

    private IMemoryRenderingType getHexRendering() {
        return this.getRenderingById(MEMORY_SPACE_RENDERING);
    }

    private IMemoryRenderingType getFloatingPointRendering() {
        return this.getRenderingById(MEMORY_SPACE_FLOATING_POINT_RENDERING);
    }

    private IMemoryRenderingType getRenderingById(String id) {
        return DebugUITools.getMemoryRenderingManager().getRenderingType(id);
    }

    private IMemoryBlockExtension createMemoryBlock(IMemoryBlockRetrieval retrieval, BigInteger baseAddress, Object context, MemorySpace memorySpace) throws DebugException {
        String expression;
        IMemoryBlockExtension block = null;
        IMemoryBlockRetrievalExtension retrievalExtension = null;
        if (retrieval instanceof IMemoryBlockRetrievalExtension) {
            retrievalExtension = (IMemoryBlockRetrievalExtension)retrieval;
        } else if (retrieval instanceof IAdaptable) {
            retrievalExtension = (IMemoryBlockRetrievalExtension)((IAdaptable)retrieval).getAdapter(IMemoryBlockRetrievalExtension.class);
        }
        if (retrievalExtension != null && (block = retrievalExtension.getExtendedMemoryBlock(expression = String.format(HEX_ADDRESS, memorySpace.getBaseAddress().toString(16)), context)) instanceof S32DbgMemoryBlock) {
            S32DbgMemoryBlock s32Block = (S32DbgMemoryBlock)block;
            s32Block.setMemorySpace(memorySpace);
            s32Block.setMemoryAccessor(this.memoryBase.getMemoryAccessor());
        }
        if (block == null) {
            MemorySpacesUIActivator.getInstance().logError(Messages.MemorySpacesViewer_memory_block_creation_failure);
        }
        return block;
    }

    public static IAdaptable getAdaptable(ISelection context) {
        if (!(context instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)context;
        if (context.isEmpty()) {
            return null;
        }
        Object elem = selection.getFirstElement();
        if (!(elem instanceof IAdaptable)) {
            return null;
        }
        return (IAdaptable)elem;
    }

    public MemoryBase getMemoryUIBase() {
        return this.memoryBase;
    }

    public void dispose() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        HashSet<GdbLaunch> gdbLaunches = new HashSet<GdbLaunch>();
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof GdbLaunch && !launch.isTerminated()) {
                gdbLaunches.add((GdbLaunch)launch);
            }
            ++n2;
        }
        this.saveMemorySpacesAdded(gdbLaunches.toArray(new GdbLaunch[0]));
        this.memoryBase.clearAll();
        DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
        super.dispose();
    }

    @Override
    public void launchTerminated(GdbLaunch launch) {
        this.saveMemorySpacesAdded(new GdbLaunch[]{launch});
        this.removeTabsBySession(launch.getSession());
    }

    @Override
    public void launchInitialized(GdbLaunch launch) {
        this.memoryBase.getMemoryAccessor().saveCurrentContext();
        this.restoreMemorySpaceAdded(launch);
        this.memoryBase.getMemoryAccessor().restoreSavedContext();
    }

    private void removeTabsBySession(DsfSession session) {
        final ArrayList<CTabItem> tabs = new ArrayList<CTabItem>(this.memoryBase.getCTabBySession(session));
        if (tabs.isEmpty()) {
            return;
        }
        UIJob job = new UIJob("Memory space remove job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                tabs.forEach(tab -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)tabs.size());
                    if (!tab.isDisposed()) {
                        tab.dispose();
                    }
                    subMonitor.worked(1);
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public CTabItem getActiveCTab() {
        return this.memoryAddressFolder.getSelection();
    }

    public void createPartControl(Composite parent) {
        IWorkbenchPartSite wbSite = this.getSite();
        this.container = new MemorySpaceRenderingContainer(this);
        wbSite.setSelectionProvider(this.container.getRenderingSelectionProvider());
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)wbSite, (IDebugContextListener)this);
        this.memoryBase.getMemoryAccessor().setCurrentContext(DebugUITools.getDebugContext());
        GridLayout gridLayout = new GridLayout(1, true);
        parent.setLayout((Layout)gridLayout);
        this.createMemoryViewer(parent);
        this.memoryBase.getMemoryAccessor().saveCurrentContext();
        Arrays.stream(DebugPlugin.getDefault().getLaunchManager().getLaunches()).filter(launch -> launch instanceof GdbLaunch && !launch.isTerminated()).forEach(launch -> this.restoreMemorySpaceAdded((GdbLaunch)launch));
        this.memoryBase.getMemoryAccessor().restoreSavedContext();
    }

    public void setAddMemorySpaceAction(IAction addMemorySpace) {
        this.actAddMemorySpace = addMemorySpace;
    }

    private void saveMemorySpacesAdded(GdbLaunch[] launches) {
        Collection<MemorySpace> spaces = this.memoryBase.getMemorySpaces();
        Arrays.asList(launches).forEach(launch -> {
            DsfSession session = launch.getSession();
            Collection<CTabItem> tabs = this.memoryBase.getCTabBySession(session);
            HashMap sessionMemento = new HashMap();
            spaces.forEach(space -> {
                for (CTabItem tab : this.memoryBase.getTabByMemorySpace((MemorySpace)space)) {
                    if (!tabs.contains(tab)) continue;
                    List<String> renderingIds = Arrays.asList((String[])this.memoryBase.getTabByMemorySpace((MemorySpace)space).stream().map(cTab -> ((MemorySpaceViewTab)((Object)((Object)((Object)cTab)))).getRenderingId()).toArray(String[]::new));
                    sessionMemento.put(space, renderingIds);
                    break;
                }
            });
            if (!sessionMemento.keySet().isEmpty()) {
                new MemorySpaceContextMemento(launch.getLaunchConfiguration().getName()).saveToMemento(sessionMemento);
            } else {
                new MemorySpaceContextMemento(launch.getLaunchConfiguration().getName()).removeMemento();
            }
        });
    }

    private void restoreMemorySpaceAdded(GdbLaunch launch) {
        boolean enabled = launch.equals(this.memoryBase.getMemoryAccessor().getLaunch());
        Map memSpaces = (Map)new MemorySpaceContextMemento(launch.getLaunchConfiguration().getName()).restoreFromMemento(new HashMap());
        this.memoryBase.getMemoryAccessor().setCurrentContext((IAdaptable)launch);
        memSpaces.keySet().forEach(memSpace -> {
            if (S32DebuggerLaunchUtils.hardwareMatchesLaunch((String)memSpace.getDevice(), (String)memSpace.getCore(), (GdbLaunch)launch)) {
                Display.getDefault().syncExec(() -> {
                    try {
                        if (((List)memSpaces.get(memSpace)).isEmpty()) {
                            ((List)memSpaces.get(memSpace)).add(MEMORY_SPACE_RENDERING);
                        }
                        for (String renderId : (List)memSpaces.get(memSpace)) {
                            this.addTabForMemorySpace((MemorySpace)memSpace, launch, this.getRenderingById(renderId));
                        }
                        memSpace.setEnabled(enabled);
                    }
                    catch (CoreException ex) {
                        MemorySpacesUIActivator.getInstance().log(ex.getStatus());
                    }
                });
            }
        });
        this.updateView();
    }

    public void switchPreviousMemSpacePage(int pageLines) {
        this.moveRendering(false, pageLines);
    }

    public void switchNextMemSpacePage(int pageLines) {
        this.moveRendering(true, pageLines);
    }

    private void moveRendering(boolean increment, int pageLines) {
        CTabItem tab = this.getActiveCTab();
        if (tab != null) {
            long moveTo;
            AbstractAsyncTableRendering rendering = (AbstractAsyncTableRendering)tab.getData(this.container.getRenderingTabDataId());
            BigInteger addr = rendering.getSelectedAddress();
            if (addr == null) {
                return;
            }
            long pageSize = Long.valueOf(rendering.getBytesPerLine()) * (long)pageLines;
            if (increment) {
                moveTo = addr.longValue() + pageSize;
            } else {
                long newAddr = addr.longValue() - pageSize;
                if (newAddr < 0L) {
                    newAddr = 0L;
                }
                moveTo = newAddr;
            }
            try {
                rendering.goToAddress(BigInteger.valueOf(moveTo));
            }
            catch (DebugException e) {
                MemorySpacesUIActivator.getInstance().logError(e.getMessage(), e);
            }
        }
    }
}

