/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cdt.core.OSFamily;
import com.freescale.s32ds.cross.core.model.IWizardValueProvider;
import com.freescale.s32ds.cross.core.model.TemplateVariable;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultWizardValueProvider
implements IWizardValueProvider {
    public static final String OP_FLASH_LENGTH = "FLASH_LENGTH";
    public static final String OP_RAM_LENGTH = "RAM_LENGTH";
    public static final String OP_NAME_SAFE = "projectNameSafe";
    public static final String OP_GROUP_SAFE = "GROUP_SAFE";
    public static final String OP_GROUP_NAME = "GROUP_NAME";
    public static final String OP_DEVICE_NAME = "DEVICE_NAME";
    public static final String PROJECT_NAME_U = "PROJECT_NAME";
    public static final String TURN_ON_CPU = "TURN_ON_CPU";
    public static final String OP_FLASH_START = "FLASH_START";
    public static final String OP_RAM_START = "RAM_START";
    public static final String PROJECT_INDEX = "PROJECT_INDEX";
    public static final String OP_NUMBER_OF_SLAVE_CORES = "NUMBER_OF_SLAVE_CORES";
    public static final String OP_CURRENT_OS = "CURRENT_OS";
    public static final String OP_CURRENT_OS_WINDOWS = "Windows";
    public static final String OP_CURRENT_OS_LINUX = "Linux";
    public static final String OP_T32_CURRENT_OS = "T32_CURRENT_OS";
    public static final String OP_T32_WINDOWS_ARCH32 = "windows";
    public static final String OP_T32_WINDOWS_ARCH64 = "windows64";
    public static final String OP_T32_LINUX_ARCH64 = "pc_linux64";
    public static final String OP_HOST_OS_EXECUTABLE_EXT = "HOST_OS_EXECUTABLE_EXT";
    public static final String OP_HOST_OS_EXECUTABLE_EXT_EXE = ".exe";
    public static final String OP_HOST_OS_EXECUTABLE_EXT_ELF = "";

    @Override
    public Map<String, String> createValueMap(ProjectContext context, String location) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Collection<TemplateVariable> vars = context.getRegistry().getTemplateVariables();
        for (TemplateVariable var : vars) {
            String v;
            boolean library;
            if (!(context instanceof CProjectMasterContext)) continue;
            boolean executable = ((CProjectMasterContext)context).isExecutable();
            boolean bl = library = !executable;
            if ((!var.isExecutable() || !executable) && (!var.isLibrary() || !library) || (v = var.getValue(context)) == null) continue;
            map.put(var.getId(), v);
        }
        if (OSFamily.WINDOWS.isCurrent()) {
            map.put(OP_CURRENT_OS, OP_CURRENT_OS_WINDOWS);
            if (EclipseUtils.isWindows64()) {
                map.put(OP_T32_CURRENT_OS, OP_T32_WINDOWS_ARCH64);
            } else {
                map.put(OP_T32_CURRENT_OS, OP_T32_WINDOWS_ARCH32);
            }
            map.put(OP_HOST_OS_EXECUTABLE_EXT, OP_HOST_OS_EXECUTABLE_EXT_EXE);
        } else if (OSFamily.LINUX.isCurrent()) {
            map.put(OP_CURRENT_OS, OP_CURRENT_OS_LINUX);
            map.put(OP_T32_CURRENT_OS, OP_T32_LINUX_ARCH64);
            map.put(OP_HOST_OS_EXECUTABLE_EXT, OP_HOST_OS_EXECUTABLE_EXT_ELF);
        }
        return map;
    }
}

