/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.dsf.session;

import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.cdt.dsf.service.DsfSession;

public abstract class DsfSessionCache<S, T> {
    private final Map<String, T> map = new HashMap<String, T>();

    public DsfSessionCache() {
        DsfSession.addSessionEndedListener(s -> {
            if (s != null) {
                this.remove(s);
            }
        });
    }

    protected void dispose(DsfSession session, T t) {
    }

    protected abstract T create(DsfSession var1, S var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(DsfSession session) {
        Map<String, T> map = this.map;
        synchronized (map) {
            return this.map.get(session.getId());
        }
    }

    public T computeIfAbsent(DsfSession session, S source) throws DsfSessionInactiveException {
        return this.computeIfAbsent(session, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T computeIfAbsent(DsfSession session, S source, Consumer<T> postCreationConsumer) throws DsfSessionInactiveException {
        Map<String, T> map = this.map;
        synchronized (map) {
            if (!session.isActive()) {
                throw new DsfSessionInactiveException(session);
            }
            T t = this.map.get(session.getId());
            if (t != null) {
                return t;
            }
            t = this.create(session, source);
            if (Objects.isNull(t)) {
                throw new IllegalStateException("Created object is null");
            }
            if (postCreationConsumer != null) {
                postCreationConsumer.accept(t);
            }
            this.map.put(session.getId(), t);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> values() {
        Map<String, T> map = this.map;
        synchronized (map) {
            return Collections.unmodifiableCollection(new ArrayList<T>(this.map.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(DsfSession session) {
        T t;
        Map<String, T> map = this.map;
        synchronized (map) {
            t = this.map.remove(session.getId());
        }
        if (t != null) {
            this.dispose(session, t);
        }
    }
}

