/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.parsers.ArmGccLegacyPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.ArmGccModernFormatPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.CwMcuPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.DsMdkPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithParser;
import com.nxp.swtools.sdkproject.parsers.IarEmbWrkbnchPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.MdkUVisionPrjAdapter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class PrjFileParserFactory {
    public static @Nullable GenericPrjAdapterWithParser getProjectFileParser(@NonNull File file, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        String fileName = file.getName();
        if (fileName.endsWith(".cproject")) {
            String fileContent = UtilsFile.readFileToString((String)file.getPath(), (Charset)StandardCharsets.UTF_8);
            if (fileContent == null) {
                return null;
            }
            if (fileContent.contains("com.freescale.dsc.cdt.toolchain")) {
                return new CwMcuPrjAdapter(file, prjDir, existingProcessorDetector);
            }
            return new DsMdkPrjAdapter(file, prjDir, existingProcessorDetector);
        }
        if (fileName.endsWith("CMakeLists.txt")) {
            String[] flagFiles = prjDir.list((dir, name) -> "flags.cmake".equals(name));
            if (flagFiles != null && flagFiles.length > 0) {
                return new ArmGccModernFormatPrjAdapter(file, prjDir, existingProcessorDetector);
            }
            return new ArmGccLegacyPrjAdapter(file, prjDir, existingProcessorDetector);
        }
        if (fileName.endsWith(".uvprojx")) {
            return new MdkUVisionPrjAdapter(file, prjDir, existingProcessorDetector);
        }
        if (fileName.endsWith(".ewp") && !fileName.startsWith("Backup of ")) {
            return new IarEmbWrkbnchPrjAdapter(file, prjDir, existingProcessorDetector);
        }
        return null;
    }
}

