/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.internal;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.DelayedActionExecutorAdapter;
import com.nxp.swtools.common.utils.runtime.DelayedExecution;
import com.nxp.swtools.common.utils.runtime.IDelayedActionExecutor;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectChangeListener;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.provider.toolchainproject.files.ProjectFilesUtils;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.SdkComponentInProjectDetector;
import com.nxp.swtools.sdkproject.internal.FileChangesWatcher;
import com.nxp.swtools.sdkproject.parsers.CwMcuPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithParser;
import com.nxp.swtools.sdkproject.parsers.PrjFileParserFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ToolchainProject4ConfigTools
implements IToolchainProjectWithSdk,
FileChangesWatcher.IFileChangeListener {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ToolchainProject4ConfigTools.class);
    @NonNull
    private final OperationMode operationMode;
    @Nullable
    private String lastProjectDetectionProblem;
    @NonNull
    final ISharedConfiguration sharedCfg;
    @NonNull
    private ProjectInfo prjInfo;
    @NonNull
    ProjectInfo newPrjInfo;
    @Nullable
    Path watchedPrjFilePath = null;
    final Collection<@NonNull IToolchainProjectChangeListener> changeListeners = new ArrayList<IToolchainProjectChangeListener>();
    Map<@NonNull String, @Nullable Boolean> knownProcessorsCache = new HashMap<String, Boolean>();
    private final DelayedExecution detectProjectDelayedExec = new DelayedExecution("Detect toolchain project", (IDelayedActionExecutor)new DelayedActionExecutorAdapter(){

        public void runAction() {
            ToolchainProject4ConfigTools.this.detectProjectAfterChange((IProgressMonitor)new NullProgressMonitor());
        }

        public void executionDone_ApplyChanges() {
            ToolchainProject4ConfigTools.this.applyNewProjectInfo();
        }

        public void executionDone_NotifyListeners() {
            ToolchainProject4ConfigTools.this.fireProjectChangeEvent();
        }
    }, 40);

    static @Nullable WatchService createWatchService() {
        if (Rap.isActive()) {
            return null;
        }
        try {
            return FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "WatchService cannot be used, changes in toolchain project file will not be detected", e);
            return null;
        }
    }

    public ToolchainProject4ConfigTools(@Nullable Path importFromPath, @Nullable IProgressMonitor monitor) {
        this.sharedCfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.prjInfo = new ProjectInfo(this);
        this.newPrjInfo = new ProjectInfo(this);
        if (importFromPath != null) {
            this.operationMode = OperationMode.IMPORT;
            this.detectProjectDelayedExec.lock(0);
            this.setProjectParameters(importFromPath, null, "", monitor);
        } else {
            this.operationMode = OperationMode.INFO_PROVIDER;
            this.updateProjectParameters();
        }
        if (this.operationMode == OperationMode.INFO_PROVIDER && !Rap.isActive()) {
            this.sharedCfg.addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

                public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
                    ToolchainProject4ConfigTools.this.updateProjectParameters();
                }

                public void commonConfigurationChanged(@NonNull ISharedConfiguration sharedConfig) {
                    ToolchainProject4ConfigTools.this.updateProjectParameters();
                }

                public void dirtyChanged(@NonNull ISharedConfiguration sharedConfiguration) {
                    ToolchainProject4ConfigTools.this.updateProjectParameters();
                }

                public int getListenerOrder() {
                    return 50;
                }
            });
        }
    }

    public ToolchainProject4ConfigTools(@NonNull Path toolchainPrjPath, @NonNull IProcessorMasterToolInfo processor, @NonNull String partNumber) {
        this.sharedCfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.prjInfo = new ProjectInfo(this);
        this.newPrjInfo = new ProjectInfo(this);
        this.operationMode = OperationMode.IMPORT;
        this.prjInfo.processor = processor;
        this.setProjectParameters(toolchainPrjPath, processor, partNumber, (IProgressMonitor)new NullProgressMonitor());
    }

    private ProjectInfo getProjectInfo() {
        if (this.operationMode != OperationMode.IMPORT) {
            this.detectProjectDelayedExec.waitUntilExecuted(8);
        }
        return this.prjInfo;
    }

    synchronized void applyNewProjectInfo() {
        ProjectInfo set_PrjInfo = this.newPrjInfo;
        this.newPrjInfo = this.newPrjInfo.clone();
        this.prjInfo = set_PrjInfo;
    }

    public @Nullable String getToolchainId() {
        return this.getProjectInfo().toolchainId;
    }

    public @Nullable String getToolchain() {
        return this.getProjectInfo().toolchainName;
    }

    public boolean wasProjectDetected() {
        if (this.prjInfo.toolchainId != null) {
            return true;
        }
        return this.getToolchain() != null;
    }

    public String getProjectDetectionProblem() {
        if (this.wasProjectDetected()) {
            return null;
        }
        return this.lastProjectDetectionProblem;
    }

    void updateProjectParameters() {
        Path path;
        if (this.operationMode == OperationMode.IMPORT) {
            path = this.prjInfo.toolchainPrjPath;
        } else {
            String mexLoc = this.sharedCfg.getLocationOnDisk();
            if (mexLoc == null) {
                path = Paths.get("", new String[0]);
            } else {
                path = Paths.get(mexLoc, new String[0]).toAbsolutePath().getParent();
                assert (path != null);
            }
        }
        if (this.sharedCfg.isEmpty()) {
            this.setProjectParameters(path, null, "", null);
        } else {
            ICommonConfig mcuSelection = this.sharedCfg.getCommonConfig();
            String masterTool = mcuSelection.getMcu();
            String sdkVersion = mcuSelection.getSdkVersion();
            String partNum = this.sharedCfg.getCommonConfig().getPackage();
            ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
            this.setProjectParameters(path, derivatives.getProcessorMasterToolInfo(masterTool, sdkVersion), partNum, null);
        }
    }

    synchronized void detectProjectAfterChange(@NonNull IProgressMonitor monitor) {
        this.newPrjInfo.toolchainId = null;
        this.newPrjInfo.toolchainName = null;
        this.newPrjInfo.core = null;
        this.newPrjInfo.projectName = "";
        this.newPrjInfo.sdkCompDetector = new SdkComponentInProjectDetector(this);
        if (this.detectProject(monitor) ? !$assertionsDisabled && (this.newPrjInfo.toolchainName == null || this.newPrjInfo.toolchainId == null) : !$assertionsDisabled && (this.newPrjInfo.toolchainName != null || this.newPrjInfo.toolchainId != null)) {
            throw new AssertionError();
        }
    }

    public void setProjectParameters(@NonNull Path prjPath, @Nullable IProcessorMasterToolInfo newProcessor, @NonNull String newPartNumber, @Nullable IProgressMonitor monitor) {
        if (!prjPath.equals(this.newPrjInfo.toolchainPrjPath) || this.newPrjInfo.processor != newProcessor || !newPartNumber.equals(this.newPrjInfo.partNumber)) {
            this.newPrjInfo.toolchainPrjPath = prjPath;
            this.newPrjInfo.processor = newProcessor;
            this.newPrjInfo.partNumber = newPartNumber;
            if (monitor != null && (!this.detectProjectDelayedExec.isExecRequested() || this.detectProjectDelayedExec.isLocked())) {
                assert (this.operationMode == OperationMode.IMPORT);
                this.detectProjectAfterChange(monitor);
                this.applyNewProjectInfo();
            } else {
                assert (this.operationMode != OperationMode.IMPORT);
                this.detectProjectDelayedExec.requestExecution();
            }
        }
    }

    private @Nullable GenericPrjAdapterWithParser findProjectFileParserForFile(@NonNull File rootDir, @NonNull File file) {
        GenericPrjAdapterWithParser parserForFile = null;
        if (file.isFile() && (parserForFile = PrjFileParserFactory.getProjectFileParser(file, rootDir, this)) == null && file.getName().endsWith(".mex")) {
            String curMexPath;
            String string = curMexPath = this.newPrjInfo.mexFile != null ? this.newPrjInfo.mexFile.getAbsolutePath() : "";
            if (curMexPath.isEmpty() || curMexPath.length() > file.getAbsolutePath().length()) {
                this.newPrjInfo.mexFile = file;
            }
        }
        return parserForFile;
    }

    private @NonNull List<@NonNull GenericPrjAdapterWithParser> findProjectFileParser(@NonNull File rootDir, @NonNull File dir) {
        List<GenericPrjAdapterWithParser> result;
        File[] files;
        if (dir.isDirectory()) {
            files = dir.listFiles();
            if (files == null) {
                if (dir.getAbsolutePath().equals(this.newPrjInfo.toolchainPrjPath.toAbsolutePath().toString())) {
                    LOGGER.severe("No files found in toolchain project: " + this.newPrjInfo.toolchainPrjPath);
                }
                return Collections.emptyList();
            }
        } else {
            if (!dir.isFile()) {
                LOGGER.severe("Directory for import not found: " + dir);
                return Collections.emptyList();
            }
            files = new File[]{dir};
        }
        if ((result = Arrays.stream(files).map(f -> this.findProjectFileParserForFile(rootDir, (File)f)).collect(Collectors.filtering(Objects::nonNull, Collectors.toList()))).size() > 1) {
            LOGGER.severe("Several toolchain project files found in project: " + this.newPrjInfo.toolchainPrjPath);
        }
        return result;
    }

    private void setPrjFileWatcher(@NonNull Path projectFilePath) {
        if (projectFilePath.equals(this.watchedPrjFilePath) || SWToolsProperties.isHeadlessOn() || this.operationMode == OperationMode.IMPORT) {
            return;
        }
        if (this.watchedPrjFilePath != null) {
            FileChangesWatcher.removeListener(this.watchedPrjFilePath, this);
            this.watchedPrjFilePath = null;
        }
        if (!projectFilePath.toString().isEmpty()) {
            this.watchedPrjFilePath = projectFilePath;
            if (!FileChangesWatcher.addListener(projectFilePath, this)) {
                this.watchedPrjFilePath = null;
            }
        }
    }

    private boolean detectProject(@NonNull IProgressMonitor monitor) {
        String pathStr;
        Path path;
        boolean canParse = true;
        if (this.newPrjInfo.toolchainPrjPath.toString().isEmpty()) {
            canParse = false;
        }
        if (canParse) {
            File toolchainPrjPathToFile = this.newPrjInfo.toolchainPrjPath.toFile();
            assert (toolchainPrjPathToFile != null);
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            List<GenericPrjAdapterWithParser> prjFileParsers = this.findProjectFileParser(toolchainPrjPathToFile, toolchainPrjPathToFile);
            sub.worked(20);
            if (prjFileParsers.size() == 1) {
                boolean projectParsed;
                GenericPrjAdapterWithParser prjFileParser = (GenericPrjAdapterWithParser)CollectionsUtils.first(prjFileParsers);
                this.lastProjectDetectionProblem = String.format(Messages.get().ImportToolchainProject_ErrUnsupportedProcessor, prjFileParser.getToolchainName());
                HashSet<@NonNull SdkComponentInProject> components = new HashSet<SdkComponentInProject>();
                HashSet<@NonNull Path> prjSources = new HashSet<Path>();
                ArrayList<@NonNull Path> inclPaths = new ArrayList<Path>();
                try {
                    projectParsed = prjFileParser.parse(components, prjSources, inclPaths, (IProgressMonitor)sub);
                }
                catch (IndexOutOfBoundsException | NumberFormatException | InvalidPathException e) {
                    projectParsed = false;
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                if (projectParsed) {
                    this.lastProjectDetectionProblem = null;
                    this.newPrjInfo.toolchainPrjPath = prjFileParser.getProjectRootPath();
                    HashMap<@NonNull String, @NonNull Path> prjSourcesMap = new HashMap<String, Path>();
                    for (Path path2 : prjSources) {
                        Path fileNamePath = path2.getFileName();
                        assert (fileNamePath != null);
                        prjSourcesMap.put(UtilsText.safeToString((Object)fileNamePath), path2);
                    }
                    this.newPrjInfo.prjSourceFiles = CollectionsUtils.unmodifiableMap(prjSourcesMap);
                    this.newPrjInfo.includePaths = CollectionsUtils.unmodifiableList(inclPaths);
                    this.newPrjInfo.componentsInRTE = CollectionsUtils.unmodifiableCollection(components);
                    this.newPrjInfo.core = prjFileParser.getDetectedCore();
                    String prjName = prjFileParser.getDetectedPrjName();
                    if (prjName == null) {
                        LOGGER.severe("[TOOL] Failed to detect project name from :" + this.newPrjInfo.toolchainPrjPath);
                    } else {
                        this.newPrjInfo.projectName = prjName;
                    }
                    this.newPrjInfo.toolchainId = prjFileParser.getToolchainId();
                    this.newPrjInfo.toolchainName = prjFileParser.getToolchainName();
                    this.newPrjInfo.partNumber = UtilsText.safeString((String)prjFileParser.getDetectPartNumber());
                    this.newPrjInfo.processor = prjFileParser.getProcessorInfo();
                    this.setPrjFileWatcher(prjFileParser.getToolchainPrjFilePath());
                    sub.done();
                    return true;
                }
                if (prjFileParser instanceof CwMcuPrjAdapter) {
                    this.lastProjectDetectionProblem = String.valueOf(this.lastProjectDetectionProblem) + "\n" + Messages.get().ImportToolchainProject_CwParseFailNote;
                }
            } else if (OperationMode.IMPORT.equals((Object)this.operationMode)) {
                if (prjFileParsers.size() > 1) {
                    Stream<String> prjFiles = prjFileParsers.stream().map(p -> Objects.requireNonNull(p.getToolchainPrjFilePath().getFileName()).toString()).sorted();
                    this.lastProjectDetectionProblem = String.format(Messages.get().ImportToolchainProject_ErrSeveralsProjectsFound, this.newPrjInfo.toolchainPrjPath.toString(), CollectionsUtils.formatList(prjFiles, (String)"; ", null));
                } else {
                    this.lastProjectDetectionProblem = String.format(Messages.get().ImportToolchainProject_ErrNoProjectFound, this.newPrjInfo.toolchainPrjPath.toString());
                }
                LOGGER.severe("[TOOL] Import: " + this.lastProjectDetectionProblem);
            }
        } else {
            this.lastProjectDetectionProblem = Messages.get().ImportToolchainProject_ErrPrjPathNotSet;
            LOGGER.warning(this.lastProjectDetectionProblem);
        }
        if (!(path = Paths.get((pathStr = this.sharedCfg.getLocationOnDisk()) != null ? pathStr : "", new String[0])).toString().isEmpty()) {
            path = path.toAbsolutePath();
        }
        this.setPrjFileWatcher(path);
        this.newPrjInfo.prjSourceFiles = CollectionsUtils.emptyUnmodifiableMap();
        this.newPrjInfo.includePaths = CollectionsUtils.emptyUnmodifiableList();
        this.newPrjInfo.componentsInRTE = CollectionsUtils.emptyUnmodifiableList();
        this.newPrjInfo.core = null;
        return false;
    }

    private @NonNull Collection<@NonNull Path> listProjectFilesByRegEx(@NonNull Pattern fileName) {
        ArrayList<@NonNull Path> result = new ArrayList<Path>();
        for (Map.Entry<String, Path> entry : this.getProjectInfo().prjSourceFiles.entrySet()) {
            if (!fileName.matcher(UtilsFile.getFileNameWithExtension((String)entry.getKey())).matches()) continue;
            Path path = entry.getValue();
            assert (path != null);
            result.add(path);
        }
        return result;
    }

    public @NonNull Collection<@NonNull Path> listProjectSources(@NonNull String fileNameMask) {
        if (fileNameMask.indexOf(42) < 0) {
            Path result = this.findSourceFileRelPath(Paths.get(fileNameMask, new String[0]));
            if (result == null) {
                return CollectionsUtils.emptyList();
            }
            ArrayList<@NonNull Path> results = new ArrayList<Path>();
            results.add(result);
            return results;
        }
        Pattern pattern = ProjectFilesUtils.createPatternForManifestFileMask((String)fileNameMask);
        return this.listProjectFilesByRegEx(pattern);
    }

    public @NonNull Collection<@NonNull Path> listProjectSourcesByRegEx(@NonNull Pattern fileNamePattern) {
        return this.listProjectFilesByRegEx(fileNamePattern);
    }

    public Path findSourceFileRelPath(@NonNull Path relFilePath) {
        Path result = this.getProjectInfo().prjSourceFiles.get(UtilsFile.getFileNameWithExtension((Path)relFilePath));
        if (result == null && !this.wasProjectDetected() && this.getSourceFileAsCachedString(relFilePath) != null) {
            return relFilePath;
        }
        return result;
    }

    public @Nullable InputStream openSourceFile(@NonNull Path fileRelPath) {
        try {
            Path filePath = this.getProjectInfo().toolchainPrjPath.resolve(fileRelPath).normalize();
            return new FileInputStream(filePath.toFile());
        }
        catch (InvalidPathException e) {
            LOGGER.log(Level.SEVERE, "Invalid path: " + fileRelPath, e);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return null;
    }

    public long getSourceModificationStamp(Path relPath) {
        Path filePath = this.getProjectInfo().toolchainPrjPath.resolve(relPath).normalize();
        return filePath.toFile().lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ISdkComponentInProject getSdkComponent(@NonNull String id) {
        ProjectInfo curPrjInfo = this.getProjectInfo();
        ToolchainProject4ConfigTools toolchainProject4ConfigTools = this;
        synchronized (toolchainProject4ConfigTools) {
            ISdkComponentInProject result = (ISdkComponentInProject)CollectionsUtils.findAny(curPrjInfo.componentsInRTE, c -> c.getID().equals(id));
            if (result != null) {
                return result;
            }
            return curPrjInfo.sdkCompDetector.getSdkComponent(id);
        }
    }

    public @Nullable String getSdkVersion() {
        return SWToolsPlatform.getSdkVersionForProcessor((String)UtilsText.safeString((String)this.getProcessor()));
    }

    public @NonNull Collection<@NonNull ISdkComponentInProject> getRteComponents() {
        ProjectInfo curPrjInfo = this.getProjectInfo();
        return new ArrayList<ISdkComponentInProject>(curPrjInfo.componentsInRTE);
    }

    public @NonNull String getProjectName() {
        return this.getProjectInfo().projectName;
    }

    public String getCoreId() {
        ProjectInfo curPrjInfo = this.prjInfo;
        if (curPrjInfo.core == null) {
            curPrjInfo = this.getProjectInfo();
        }
        return curPrjInfo.core != null ? curPrjInfo.core.getID() : null;
    }

    public String getPartNumber() {
        ProjectInfo curPrjInfo = this.getProjectInfo();
        return curPrjInfo.partNumber.isEmpty() ? null : curPrjInfo.partNumber;
    }

    public @Nullable String getProcessor() {
        ProjectInfo curPrjInfo = this.getProjectInfo();
        return curPrjInfo.processor != null ? curPrjInfo.processor.getId() : null;
    }

    public boolean canAddAdditionalComponents() {
        assert (this.operationMode == OperationMode.INFO_PROVIDER);
        return false;
    }

    public boolean addComponent(@NonNull String compId) {
        assert (this.operationMode == OperationMode.INFO_PROVIDER);
        return false;
    }

    public boolean addComponents(@NonNull List<@NonNull String> compIds) {
        assert (this.operationMode == OperationMode.INFO_PROVIDER);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(@NonNull IToolchainProjectChangeListener listener) {
        assert (this.operationMode == OperationMode.INFO_PROVIDER);
        Collection<IToolchainProjectChangeListener> collection = this.changeListeners;
        synchronized (collection) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(@NonNull IToolchainProjectChangeListener listener) {
        assert (this.operationMode == OperationMode.INFO_PROVIDER);
        Collection<IToolchainProjectChangeListener> collection = this.changeListeners;
        synchronized (collection) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireProjectChangeEvent() {
        Collection<IToolchainProjectChangeListener> collection = this.changeListeners;
        synchronized (collection) {
            this.changeListeners.forEach(l -> l.projectChanged());
        }
    }

    public Path getProjectRoot() {
        return this.getProjectInfo().toolchainPrjPath;
    }

    public @NonNull Stream<@NonNull String> listFiles(@NonNull Path relDir) {
        String relDirStr = UtilsFile.toEclipsePath((String)relDir.toString());
        Stream<@NonNull String> result = this.getProjectInfo().prjSourceFiles.entrySet().stream().filter(e -> relDirStr.equals(UtilsFile.getFilePath((String)Objects.requireNonNull(((Path)e.getValue()).getFileName()).toString()))).map(e -> (String)e.getKey());
        assert (result != null);
        return result;
    }

    public @NonNull Stream<@NonNull String> listSubDirectories(@NonNull Path relDir) {
        Stream<@NonNull String> result = this.getProjectInfo().prjSourceFiles.values().stream().filter(p -> p.startsWith(relDir) && relDir.relativize((Path)p).getNameCount() > 0).map(p -> relDir.relativize((Path)p).getName(0).toString());
        assert (result != null);
        return result;
    }

    public List<@NonNull Path> getIncludePaths() {
        return this.getProjectInfo().includePaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.setPrjFileWatcher(Paths.get("", new String[0]));
        Collection<IToolchainProjectChangeListener> collection = this.changeListeners;
        synchronized (collection) {
            this.changeListeners.clear();
        }
        this.detectProjectDelayedExec.lock(0);
    }

    public boolean isProjectAccessible() {
        return true;
    }

    public @Nullable IProject getEclipseProject() {
        return null;
    }

    @Override
    public void fileChanged(boolean changedFileContent) {
        if (changedFileContent) {
            this.detectProjectDelayedExec.requestExecution();
        } else {
            File toolchainPrjPathToFile = this.getProjectInfo().toolchainPrjPath.toFile();
            assert (toolchainPrjPathToFile != null);
            List<GenericPrjAdapterWithParser> prjFileParsers = this.findProjectFileParser(toolchainPrjPathToFile, toolchainPrjPathToFile);
            if (prjFileParsers.isEmpty() || prjFileParsers.stream().noneMatch(p -> p.getToolchainPrjFilePath().equals(this.watchedPrjFilePath))) {
                this.detectProjectDelayedExec.requestExecution();
            }
        }
    }

    public boolean existsProcessor(@NonNull String processor) {
        Boolean result;
        if (this.knownProcessorsCache.containsKey(processor)) {
            result = this.knownProcessorsCache.get(processor);
        } else {
            result = KExProcessorsProvider.checkOrDownloadProcessor((String)processor, (String)SWToolsPlatform.getSdkVersionForProcessor((String)processor), (boolean)false).isProcessorPresent();
            this.knownProcessorsCache.put(processor, result);
        }
        return Boolean.TRUE.equals(result);
    }

    public void logProblemsInSdkComponentDetection() {
        this.getProjectInfo().sdkCompDetector.logProblemsInSdkComponentDetection();
    }

    public boolean deleteFile(@NonNull Path relPath) {
        Path absPath = this.getProjectRoot().resolve(relPath);
        try {
            return Files.deleteIfExists(absPath);
        }
        catch (IOException | SecurityException e) {
            LOGGER.log(Level.SEVERE, "Failed to delete: " + absPath.toString(), e);
            return false;
        }
    }

    public boolean deleteFileSafe(@NonNull Path relPath) {
        return this.deleteFile(relPath);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IToolchainProjectWithSdk.SecureProjectType getSecureProjectType() {
        return IToolchainProjectWithSdk.SecureProjectType.NOT_DETECTED;
    }

    private static enum OperationMode {
        IMPORT,
        INFO_PROVIDER;

    }

    static class ProjectInfo {
        @Nullable
        String toolchainId;
        @Nullable
        String toolchainName;
        @NonNull
        Path toolchainPrjPath = Paths.get("", new String[0]);
        @NonNull
        @NonNull Collection<@NonNull SdkComponentInProject> componentsInRTE = new ArrayList<SdkComponentInProject>();
        @NonNull
        SdkComponentInProjectDetector sdkCompDetector;
        @NonNull
        @NonNull Map<@NonNull String, Path> prjSourceFiles = CollectionsUtils.emptyUnmodifiableMap();
        @NonNull
        @NonNull List<@NonNull Path> includePaths = CollectionsUtils.emptyUnmodifiableList();
        @Nullable
        IProcessorMasterToolInfo processor;
        @NonNull
        String partNumber = "";
        @Nullable
        ProcessorCore core;
        @NonNull
        String projectName = "";
        @Nullable
        File mexFile;

        ProjectInfo(@NonNull IToolchainProjectWithSdk sdkProject) {
            this.sdkCompDetector = new SdkComponentInProjectDetector(sdkProject);
        }

        ProjectInfo(@NonNull SdkComponentInProjectDetector sdkCompDetector) {
            this.sdkCompDetector = sdkCompDetector;
        }

        protected @NonNull ProjectInfo clone() {
            ProjectInfo result = new ProjectInfo(this.sdkCompDetector);
            result.toolchainPrjPath = this.toolchainPrjPath;
            result.processor = this.processor;
            result.partNumber = this.partNumber;
            return result;
        }
    }
}

