/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.sources.OverriddenDestinationPathProvider;
import com.nxp.swtools.provider.configuration.storage.OutputPathOverrideRule;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import java.nio.file.Path;
import java.util.List;

public class ToolchainProjectDestinationPathProvider
extends OverriddenDestinationPathProvider {
    @NonNull
    private final IToolchainProjectWithSdk sdkProject;

    public ToolchainProjectDestinationPathProvider(@NonNull IToolchainProjectWithSdk sdkProject, @NonNull String subDir, @Nullable List<@NonNull OutputPathOverrideRule> overrideRules) {
        super(sdkProject.getProjectRoot().resolve(subDir), overrideRules);
        this.sdkProject = sdkProject;
    }

    public @NonNull Path getDestinationPath(String relFilePathStr) {
        Path path;
        Path relFilePath = super.getDestinationPath(relFilePathStr);
        if (!this.sdkProject.getProjectRoot().toString().isEmpty()) {
            relFilePath = this.sdkProject.getProjectRoot().relativize(relFilePath);
        }
        if ((path = this.sdkProject.findSourceFileRelPath(relFilePath)) == null) {
            path = relFilePath;
        }
        path = this.sdkProject.getProjectRoot().resolve(path).normalize();
        assert (path != null);
        return path;
    }

    public @NonNull Path getDestPathProjectRelative(@NonNull String filePath) {
        Path result = this.getDestinationPath(filePath);
        if (!this.sdkProject.getProjectRoot().toString().isEmpty()) {
            result = this.sdkProject.getProjectRoot().relativize(result);
        }
        return result;
    }

    public String toString() {
        return "ToolchainProjectDestinationPathProvider [sdkProject=" + this.sdkProject + ", targetPath=" + this.getTargetPath() + "]";
    }
}

