/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.epc.model;

import com.nxp.swtools.asr.convertor.AsrImporterHelper;
import com.nxp.swtools.asr.epc.model.Entry;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="peripherals_clocks_mappings")
public class PeripheralsClocksMappings {
    private static final Logger LOGGER = LogManager.getLogger(PeripheralsClocksMappings.class);
    private static final String PERIPHERAL_CLOCKS_MAPPING_FILE_NAME = "peripheralsClocksMapping.xml";
    @ElementList(type=Entry.class, required=true, inline=true)
    private List<Entry> entries;

    protected PeripheralsClocksMappings() {
        this(new ArrayList<Entry>());
    }

    public PeripheralsClocksMappings(List<Entry> entries) {
        this.entries = entries;
    }

    public static void loadClocksPeripheralsMappingFile() {
        Path systemComponentDir;
        File clocksPeripheralsMappingFile;
        ConfigurationComponentTypeId systemComponent = Controller.getInstance().getSystemComponent();
        if (systemComponent != null && (clocksPeripheralsMappingFile = (systemComponentDir = systemComponent.getFileLocation()).resolve(PERIPHERAL_CLOCKS_MAPPING_FILE_NAME).toFile()).exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream configClassesInStr = UtilsDecryption.getFileInputStream((File)clocksPeripheralsMappingFile);){
                    Persister serializer = new Persister();
                    PeripheralsClocksMappings result = (PeripheralsClocksMappings)serializer.read(PeripheralsClocksMappings.class, configClassesInStr);
                    Map<String, String> peripheralsClocksMapping = AsrImporterHelper.getInstance().getPeripheralClocksMapping();
                    if (peripheralsClocksMapping.isEmpty()) {
                        for (Entry entry : result.getEntries()) {
                            peripheralsClocksMapping.put(entry.getKey(), entry.getValue());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.warning(MessageFormat.format("[DATA] The following exception occured when trying to read the content of {0} file {1}.", PERIPHERAL_CLOCKS_MAPPING_FILE_NAME, e.getLocalizedMessage()));
            }
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeripheralsClocksMappings other = (PeripheralsClocksMappings)obj;
        return Objects.equals(this.entries, other.entries);
    }
}

