/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.databinding;

import com.nxp.s32ds.ext.rcp.databinding.internal.validation.GroupDescriptorImpl;
import com.nxp.s32ds.ext.rcp.databinding.internal.validation.ValidationDescriptorImpl;
import com.nxp.s32ds.ext.rcp.databinding.internal.validation.ValidationGroupDescriptorImpl;
import com.nxp.s32ds.ext.rcp.databinding.validation.registry.GroupRegistry;
import com.nxp.s32ds.ext.rcp.databinding.validation.registry.ValidationRegistry;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DatabindingActivator
extends RcpBundle {
    private static final String ID_ATTRIBUTE = "id";
    private static final String BUNDLE_ID = "com.nxp.s32ds.ext.rcp.databinding";
    private static final String VALIDATION_EXT_POINT = "validations";
    public static final String GROUP_ATTRIBUTE = "group";
    public static final String VALIDATION_ATTRIBUTE = "validator";
    public static final String VALIDATION_GROUP_ATTRIBUTE = "validatorGroup";
    public static final String CLASS_ATTRIBUTE = "class";
    private static BundleContext context;
    private static DatabindingActivator INSTANCE;
    private ServiceTracker<ValidationRegistry, ValidationRegistry> validatoinRegistryServiceTracker;
    private ServiceTracker<GroupRegistry, GroupRegistry> groupRegistryServiceTracker;
    private ValidationRegistry validationRegistryService;
    private GroupRegistry groupRegistryService;

    public static DatabindingActivator getInstance() {
        return INSTANCE;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        INSTANCE = this;
        String validatoinRegistryClassName = ValidationRegistry.class.getName();
        this.validatoinRegistryServiceTracker = new ServiceTracker(context, validatoinRegistryClassName, null);
        this.validatoinRegistryServiceTracker.open();
        this.validationRegistryService = (ValidationRegistry)this.validatoinRegistryServiceTracker.getService();
        this.registerValidators(this.validationRegistryService);
        String groupRegistryClassName = GroupRegistry.class.getName();
        this.groupRegistryServiceTracker = new ServiceTracker(context, groupRegistryClassName, null);
        this.groupRegistryServiceTracker.open();
        this.groupRegistryService = (GroupRegistry)this.groupRegistryServiceTracker.getService();
        this.registerGroups(this.groupRegistryService);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        INSTANCE = null;
        context = null;
    }

    private void registerValidators(ValidationRegistry registry) {
        List validationElements = Extensions.getConfigrationElements((String)BUNDLE_ID, (String)VALIDATION_EXT_POINT, (String)VALIDATION_ATTRIBUTE, (String[])new String[]{ID_ATTRIBUTE});
        for (IConfigurationElement element : validationElements) {
            ValidationDescriptorImpl validationDescriptor = new ValidationDescriptorImpl(element);
            registry.addValidationDescriptor(validationDescriptor);
        }
        List validationGroupElements = Extensions.getConfigrationElements((String)BUNDLE_ID, (String)VALIDATION_EXT_POINT, (String)VALIDATION_GROUP_ATTRIBUTE, (String[])new String[0]);
        for (IConfigurationElement element : validationGroupElements) {
            ValidationGroupDescriptorImpl validatorGroupDescr = new ValidationGroupDescriptorImpl(element);
            registry.addValidationGroupDescriptor(validatorGroupDescr);
        }
    }

    private void registerGroups(GroupRegistry registry) {
        List groupElements = Extensions.getConfigrationElements((String)BUNDLE_ID, (String)VALIDATION_EXT_POINT, (String)GROUP_ATTRIBUTE, (String[])new String[]{ID_ATTRIBUTE});
        for (IConfigurationElement element : groupElements) {
            GroupDescriptorImpl groupDescriptor = new GroupDescriptorImpl(element);
            registry.addGroupDescriptor(groupDescriptor);
        }
    }

    public ValidationRegistry getRegistry() {
        return this.validationRegistryService;
    }

    protected String getBundleId() {
        return BUNDLE_ID;
    }
}

