/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.environment;

import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class EnvironmentSdkRegistryImplementation
extends BaseRegistry
implements EnvironmentSdkRegistry {
    private final Map<String, Collection<EnvironmentSdkDescriptor>> environment2environmentSdkDescriptors = new HashMap<String, Collection<EnvironmentSdkDescriptor>>();
    private final Map<String, Collection<EnvironmentSdkDescriptor>> sdk2environmentSdkDescriptors = new HashMap<String, Collection<EnvironmentSdkDescriptor>>();

    @Override
    public List<EnvironmentSdkDescriptor> getEnvironmentSdkDescriptorsByName(String name) {
        return this.getReferenceDescriptorsBySourceId(name, this.environment2environmentSdkDescriptors, EnvironmentSdkDescriptor.class);
    }

    @Override
    public List<EnvironmentSdkDescriptor> getEnvironmentSdkDescriptorsBySdkId(String sdkId) {
        return this.getReferenceDescriptorsByTargetId(sdkId, this.sdk2environmentSdkDescriptors, EnvironmentSdkDescriptor.class);
    }

    @Override
    public void addEnvironmentSdkDescriptor(EnvironmentSdkDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.environment2environmentSdkDescriptors, this.sdk2environmentSdkDescriptors, EnvironmentSdkDescriptor.class);
    }

    @Override
    public void removeEnvironmentSdkDescriptor(EnvironmentSdkDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.environment2environmentSdkDescriptors, this.sdk2environmentSdkDescriptors, EnvironmentSdkDescriptor.class);
    }

    @Override
    public void removeEnvironmentSdkDescriptorsBySdkId(String sdkId) {
        Collection<EnvironmentSdkDescriptor> collection = this.sdk2environmentSdkDescriptors.get(sdkId);
        if (collection != null) {
            ArrayList<EnvironmentSdkDescriptor> descriptors = new ArrayList<EnvironmentSdkDescriptor>(collection);
            descriptors.forEach(this::removeEnvironmentSdkDescriptor);
            descriptors.clear();
        }
    }

    @Override
    public List<EnvironmentSdkDescriptor> getEnvironmentSdkDescriptors() {
        return this.environment2environmentSdkDescriptors.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

