/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.refactoring.text;

import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextMatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;

public class IdeTextSearchRequestor<T extends IdeTextMatch>
extends TextSearchRequestor {
    private final List<T> matches = new ArrayList<T>();
    private final Function<TextSearchMatchAccess, T> function;

    public static IdeTextSearchRequestor<IdeTextMatch> create(String searchString) {
        return new IdeTextSearchRequestor<IdeTextMatch>(new DefaultFunction(searchString));
    }

    protected IdeTextSearchRequestor(Function<TextSearchMatchAccess, T> function) {
        this.function = function;
    }

    public boolean acceptPatternMatch(TextSearchMatchAccess access) {
        IdeTextMatch t = (IdeTextMatch)this.function.apply(access);
        if (t != null) {
            this.matches.add(t);
        }
        return true;
    }

    public List<T> getMatches() {
        return Collections.unmodifiableList(this.matches);
    }

    private static final class DefaultFunction
    implements Function<TextSearchMatchAccess, IdeTextMatch> {
        private final String searchString;

        public DefaultFunction(String searchString) {
            this.searchString = searchString;
        }

        @Override
        public IdeTextMatch apply(TextSearchMatchAccess access) {
            return new IdeTextMatch(this.searchString, access.getFile(), access.getMatchOffset(), access.getMatchLength());
        }
    }
}

