/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.refactoring.text;

import com.ibm.icu.text.Collator;
import java.util.Objects;
import org.eclipse.core.resources.IFile;

public class IdeTextMatch
implements Comparable<IdeTextMatch> {
    protected final String searchString;
    protected final IFile file;
    protected final int offset;
    protected final int length;

    public IdeTextMatch(String searchString, IFile file, int offset, int length) {
        this.searchString = searchString;
        this.file = file;
        this.offset = offset;
        this.length = length;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public IFile getFile() {
        return this.file;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return "\"" + this.getSearchString() + "\" in " + this.getFile() + " [" + this.getOffset() + ":" + this.getLength() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.file, this.length, this.offset, this.searchString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IdeTextMatch)) {
            return false;
        }
        IdeTextMatch other = (IdeTextMatch)obj;
        return Objects.equals(this.file, other.file) && this.length == other.length && this.offset == other.offset && Objects.equals(this.searchString, other.searchString);
    }

    @Override
    public int compareTo(IdeTextMatch another) {
        String p1 = this.getFile().getFullPath().toString();
        String p2 = another.getFile().getFullPath().toString();
        int result = Collator.getInstance().compare(p1, p2);
        if (result != 0) {
            return result;
        }
        return this.getOffset() - another.getOffset();
    }
}

