/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.internal.refactoring.text;

import com.nxp.s32ds.ext.ide.internal.refactoring.Messages;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextEdit;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextMatch;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class IdeTextLineEdit
extends IdeTextEdit {
    public IdeTextLineEdit(IdeTextMatch match) {
        super(match);
    }

    protected int getLineNumber(IDocument document) throws BadLocationException {
        return document.getLineOfOffset(this.match.getOffset());
    }

    public static IdeTextEdit deleteLine(IdeTextMatch match) {
        return new IdeTextLineEdit(match){

            @Override
            public String getDescription() {
                return Messages.IdeTextLineEdit_delete_line;
            }

            @Override
            public TextEdit createTextEdit(IDocument document) throws BadLocationException {
                return this.deleteLine(document);
            }
        };
    }

    public static IdeTextEdit insertLineBefore(IdeTextMatch match, final String text) {
        return new IdeTextLineEdit(match){

            @Override
            public String getDescription() {
                return Messages.IdeTextLineEdit_insert_line;
            }

            @Override
            public TextEdit createTextEdit(IDocument document) throws BadLocationException {
                return this.insertLineBefore(document, text);
            }
        };
    }

    public static IdeTextEdit insertLineAfter(IdeTextMatch match, final String text) {
        return new IdeTextLineEdit(match){

            @Override
            public String getDescription() {
                return Messages.IdeTextLineEdit_insert_line;
            }

            @Override
            public TextEdit createTextEdit(IDocument document) throws BadLocationException {
                return this.insertLineAfter(document, text);
            }
        };
    }

    public static IdeTextEdit prependText(IdeTextMatch match, final String text) {
        return new IdeTextLineEdit(match){

            @Override
            public String getDescription() {
                return Messages.IdeTextLineEdit_insert_text;
            }

            @Override
            public TextEdit createTextEdit(IDocument document) throws BadLocationException {
                return this.prependText(document, text);
            }
        };
    }

    public static IdeTextEdit appendText(IdeTextMatch match, final String text) {
        return new IdeTextLineEdit(match){

            @Override
            public String getDescription() {
                return Messages.IdeTextLineEdit_insert_text;
            }

            @Override
            public TextEdit createTextEdit(IDocument document) throws BadLocationException {
                return this.appendText(document, text);
            }
        };
    }

    protected TextEdit deleteLine(IDocument document) throws BadLocationException {
        int line = this.getLineNumber(document);
        return new DeleteEdit(document.getLineOffset(line), document.getLineLength(line));
    }

    protected TextEdit insertLineBefore(IDocument document, String text) throws BadLocationException {
        int line = this.getLineNumber(document);
        text = String.valueOf(text) + document.getLineDelimiter(line);
        return new InsertEdit(document.getLineOffset(line), text);
    }

    protected TextEdit insertLineAfter(IDocument document, String text) throws BadLocationException {
        int line = this.getLineNumber(document);
        text = String.valueOf(text) + document.getLineDelimiter(line);
        return new InsertEdit(document.getLineOffset(line) + document.getLineLength(line), text);
    }

    protected TextEdit prependText(IDocument document, String text) throws BadLocationException {
        int line = this.getLineNumber(document);
        return new InsertEdit(document.getLineOffset(line), text);
    }

    protected TextEdit appendText(IDocument document, String text) throws BadLocationException {
        int line = this.getLineNumber(document);
        IRegion lineInformation = document.getLineInformation(line);
        return new InsertEdit(lineInformation.getOffset() + lineInformation.getLength(), text);
    }
}

