/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.software.manager;

import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManifestFilesManager;
import com.nxp.s32ds.cle.runtime.software.manager.utils.SoftwareManagerIOUtils;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class SoftwareManifestHandler {
    public static final String STORED_SOFTWARE_FILES_MD5 = "storedSoftwareFilesMD5";
    private static final String FILE_MD5_SUM = "fileMD5Sum";
    private static final String FILES_MD5_SUMS = "fileMD5Sums";
    private static final String ATR_MD5 = "md5";
    private static final String ROOT = "root";
    private final SoftwareManifestFilesManager softwareManifestFilesManager;

    public SoftwareManifestHandler(SoftwareManifestFilesManager softwareManifestFilesManager) {
        this.softwareManifestFilesManager = softwareManifestFilesManager;
    }

    private static Set<String> loadStoredMD5Sum(String location) throws WorkbenchException {
        HashSet<String> storedMapFileLocation2MD5 = new HashSet<String>();
        if (location == null || location.isEmpty()) {
            return storedMapFileLocation2MD5;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (StringReader reader = new StringReader(location);){
            XMLMemento mementoRoot = XMLMemento.createReadRoot((Reader)reader);
            IMemento mementoDecscriptors = mementoRoot.getChild(FILES_MD5_SUMS);
            IMemento[] iMementoArray = mementoDecscriptors.getChildren();
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento mementoDecscriptor = iMementoArray[n2];
                String md5HexSumm = mementoDecscriptor.getString(ATR_MD5);
                storedMapFileLocation2MD5.add(md5HexSumm);
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return storedMapFileLocation2MD5;
    }

    private void storedMD5Sum(Set<String> currentMapMD5HexSet) throws IOException {
        if (currentMapMD5HexSet == null || currentMapMD5HexSet.isEmpty()) {
            return;
        }
        XMLMemento createWriteRoot = XMLMemento.createWriteRoot((String)ROOT);
        IMemento mementoDecscriptors = createWriteRoot.createChild(FILES_MD5_SUMS);
        for (String string : currentMapMD5HexSet) {
            IMemento mementoSoftwareManagerPackageDescriptor = mementoDecscriptors.createChild(FILE_MD5_SUM);
            mementoSoftwareManagerPackageDescriptor.putString(ATR_MD5, string);
        }
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (StringWriter writer = new StringWriter();){
            createWriteRoot.save((Writer)writer);
            this.softwareManifestFilesManager.storeMD5SumPropirties(writer.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Set<String> calculateStoredMD5(Set<String> fileLocations) throws NoSuchAlgorithmException, IOException {
        HashSet<String> set = new HashSet<String>();
        if (fileLocations == null || fileLocations.isEmpty()) {
            return set;
        }
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        for (String string : fileLocations) {
            try {
                File file = new File(stringVariableManager.performStringSubstitution(string));
                if (!file.exists()) {
                    this.softwareManifestFilesManager.fileNotExistsErrorHandling(string);
                    break;
                }
                set.add(SoftwareManagerIOUtils.getMD5ForFile(file));
            }
            catch (CoreException e) {
                this.softwareManifestFilesManager.stringSubstitutionErrorHandling(e.getMessage());
            }
        }
        return set;
    }

    public final boolean isFilesChanged(RcpBundle bundle) throws WorkbenchException {
        Set<String> currentMapMD5HexSet;
        block7: {
            String storedPreferensString;
            block6: {
                currentMapMD5HexSet = this.calculateStoredMD5(this.softwareManifestFilesManager.getCurrentFilesLocation());
                storedPreferensString = this.softwareManifestFilesManager.getMD5Properties();
                if (storedPreferensString != null && !storedPreferensString.isEmpty()) break block6;
                if (currentMapMD5HexSet == null || currentMapMD5HexSet.isEmpty()) {
                    return false;
                }
                break block7;
            }
            Set<String> loadStoredMD5Sum = SoftwareManifestHandler.loadStoredMD5Sum(storedPreferensString);
            if (!currentMapMD5HexSet.equals(loadStoredMD5Sum)) break block7;
            return false;
        }
        try {
            this.storedMD5Sum(currentMapMD5HexSet);
        }
        catch (NoSuchAlgorithmException e) {
            bundle.logError("MD5 algorithm does not supported", (Throwable)e);
        }
        catch (IOException e) {
            bundle.logError("Could read file for MD5 ", (Throwable)e);
        }
        return true;
    }
}

