/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.GenericCache;
import com.nxp.swtools.common.utils.text.UtilsText;
import org.w3c.dom.Element;

public class SdkTagContentVersion
implements Comparable<SdkTagContentVersion> {
    @NonNull
    public static final String DEFAULT_VALUE = "1.0";
    @NonNull
    public static final String OLD_UNUSED_VERSION = "0";
    @NonNull
    public static final String DEFAULT_REVISION = "";
    @NonNull
    private final String version;
    @NonNull
    private final String revision;
    @NonNull
    private static GenericCache<@Nullable SdkTagContentVersion> cacheSdkVersions = new GenericCache();

    private SdkTagContentVersion(@NonNull String version, @NonNull String revision) {
        if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        this.version = version;
        this.revision = revision;
    }

    public final @NonNull String getVersionStr() {
        return this.version;
    }

    public final @NonNull String getRevision() {
        return this.revision;
    }

    public final String getVersionAndRevisionAttributes() {
        return " version=\"" + this.getVersionStr() + '\"' + (this.revision.isEmpty() ? DEFAULT_REVISION : " revision=\"" + this.getRevision() + '\"');
    }

    @Override
    public int compareTo(@Nullable SdkTagContentVersion cmpVersion) {
        if (cmpVersion == null) {
            return 1;
        }
        String myVersionStr = this.getVersionStr();
        String cmpVersionStr = cmpVersion.getVersionStr();
        String[] myNumbers = myVersionStr.split("\\.");
        String[] cmpNumbers = cmpVersionStr.split("\\.");
        int length = Math.max(myNumbers.length, cmpNumbers.length);
        int i = 0;
        while (i < length) {
            int cmpNum;
            int myNum = i < myNumbers.length ? Integer.parseInt(myNumbers[i]) : 0;
            int n = cmpNum = i < cmpNumbers.length ? Integer.parseInt(cmpNumbers[i]) : 0;
            if (myNum < cmpNum) {
                return -1;
            }
            if (myNum > cmpNum) {
                return 1;
            }
            ++i;
        }
        return this.revision.compareTo(cmpVersion.getRevision());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((SdkTagContentVersion)obj) == 0;
    }

    public int hashCode() {
        return this.revision.hashCode() * 17 + this.version.hashCode();
    }

    public @NonNull SdkTagContentVersion getIncremented() {
        if (this.version.length() < 3 || this.version.equals(DEFAULT_VALUE)) {
            return SdkTagContentVersion.valueOf(String.valueOf(this.version) + ".1", this.revision);
        }
        String myVersionStr = this.getVersionStr();
        String[] myNumbers = myVersionStr.split("\\.");
        int maxInd = myNumbers.length - 1;
        myNumbers[maxInd] = String.valueOf(Integer.parseInt(myNumbers[maxInd]) + 1);
        StringBuilder result = new StringBuilder();
        String[] stringArray = myNumbers;
        int n = myNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String num = stringArray[n2];
            if (result.length() > 0) {
                result.append('.');
            }
            result.append(num);
            ++n2;
        }
        return SdkTagContentVersion.valueOf(UtilsText.safeToString((Object)result), this.revision);
    }

    public static @NonNull SdkTagContentVersion valueOf(@NonNull String version, @NonNull String revision) {
        return (SdkTagContentVersion)cacheSdkVersions.nonNullCache((Object)new SdkTagContentVersion(version, revision));
    }

    public static @NonNull SdkTagContentVersion valueOf(@NonNull Element tag) {
        String revision;
        String version = tag.getAttribute("version");
        if (version.isEmpty()) {
            version = DEFAULT_VALUE;
        }
        if ((revision = tag.getAttribute("revision")).isEmpty()) {
            revision = DEFAULT_REVISION;
        }
        return SdkTagContentVersion.valueOf(version, revision);
    }
}

