/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr.importer;

import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.ddr.controller.DDRController;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.JTAGConnection;
import com.nxp.swtools.mem.validation.connections.ui.JtagConnectionParamView;
import com.nxp.swtools.mem.validation.integration.ddr.Messages;
import com.nxp.swtools.mem.validation.integration.ddr.importer.DdrImportMemoryRunnable;
import com.nxp.swtools.mem.validation.integration.ddr.importer.ImportTargetConfigDialog;
import com.nxp.swtools.mem.validation.integration.ddr.importer.RPAImportedData;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import com.nxp.swtools.utils.dialog.ToolsProgressMonitorDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ImportTargetDDRConfigDialog
extends ImportTargetConfigDialog {
    private static final String DS_FILE_NAME = "ddr_config.ds";
    RPAImportedData importedData = RPAImportedData.getInstance();

    public ImportTargetDDRConfigDialog(Shell parent, IConfigProvider configProvider) {
        super(parent, configProvider, DDRController.getInstance().getFileProvider());
        this.configProvider = configProvider;
    }

    protected void okPressed() {
        if (this.connView != null) {
            JTAGConnection data;
            Control conn = this.connView.getConnConfigComposite().getChildren()[0];
            if (conn instanceof JtagConnectionParamView && (data = ((JtagConnectionParamView)conn).getCurrentConnection()) != null) {
                ValidationContext.getInstance().setCurrentConnection((Connection)data);
            }
            File tmpDir = UtilsFile.createTempSubDirectory((String)"mem_validation");
            String dsName = String.valueOf(tmpDir.getAbsolutePath()) + File.separator + DS_FILE_NAME;
            try {
                Shell shell = conn.getShell();
                ToolsProgressMonitorDialog dlg = new ToolsProgressMonitorDialog(shell);
                dlg.run(true, false, (IRunnableWithProgress)new DdrImportMemoryRunnable(this.profileProvider, this.compiledScript, this.resourceFileProvider));
                String rawOutput = ValidationContext.getInstance().getOutput();
                String error = VLoggingUtils.extractErrorMessage((String)rawOutput);
                if (!error.isEmpty()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportDDRTargetFailedTitle, (String)error);
                } else {
                    boolean success = this.importedData.loadDataFromFile(dsName);
                    if (!success) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportDDRTargetFailedTitle, (String)Messages.ImportDDRTargetFailed);
                    } else {
                        this.importedData.apply();
                    }
                }
            }
            catch (InvocationTargetException ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportDDRTargetFailedTitle, (String)ex.getMessage());
            }
            catch (InterruptedException ex) {
                String rawOutput = ValidationContext.getInstance().getOutput();
                String error = VLoggingUtils.extractErrorMessage((String)rawOutput);
                if (!error.isEmpty()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportDDRTargetFailedTitle, (String)error);
                }
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportDDRTargetFailedTitle, (String)ex.getMessage());
            }
        }
        super.okPressed();
    }
}

