/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr.codegen;

import com.nxp.swtools.ddr.codegen.CodeGenerationController;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.integration.ddr.Messages;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import com.nxp.swtools.utils.scripting.ScriptResult;
import java.util.Collection;
import java.util.Map;

public class DDRSourceCodeGeneration
implements ISourceFileProvider {
    public ISourceFileGenerationStatus getGeneratedFiles(String coreId, Collection<ISourceFile> generatedFiles) {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        ScriptResult scriptResult = configController != null && configController.isEnabled() ? Activator.getDefault().getCgenManager().getScriptResult() : CodeGenerationController.getInstance().getScriptResult();
        if (scriptResult != null) {
            if (scriptResult.isFailed()) {
                return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.FATAL, (String)Messages.CodeGenerationFailed);
            }
            String errors = scriptResult.getErrors();
            if (!errors.isEmpty()) {
                return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.ERRORS, (String)errors);
            }
            generatedFiles.addAll(SourceFileProviderFactory.buildSourceFileList((Map)scriptResult.getOpenedFiles(), (ICustomCopyrightHeaderRead)SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getCustomCopyright()));
            String warnings = scriptResult.getWarnings();
            if (!warnings.isEmpty()) {
                return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.WARNING, (String)warnings);
            }
        }
        return SourceFileProviderFactory.buildGenerationOKStatus();
    }
}

