/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.vdk;

import com.nxp.s32ds.cle.debug.internal.vdk.VDKHardwareDebuggingLaunchConfigurationActivator;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.debugger.registry.Configuration;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class VDKHardwareDebuggingLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    private static final String LOCALHOST = "localhost";
    private static final String GENERIC_TCP_IP = "Generic TCP/IP";
    private static final String DEBUGGER_ID = "vdk";
    private static final String JTAG_LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.cdt.debug.gdbjtag.launchConfigurationType";
    private static final String ATTR_GDB_JTAG_DEVICE = "org.eclipse.cdt.debug.gdbjtag.core.jtagDevice";
    private static final String ATTR_GDB_JTAG_IP_ADDRESS = "org.eclipse.cdt.debug.gdbjtag.core.ipAddress";
    private static final String ATTR_GDB_JTAG_PORT_NUMBER = "org.eclipse.cdt.debug.gdbjtag.core.portNumber";
    private static final String ATTR_DSF_GDB_DEBUG_NAME = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String ATTR_GDB_DELAY = "org.eclipse.cdt.debug.gdbjtag.core.delay";
    private static final String ATTR_GDB_INIT_COMMANDS = "org.eclipse.cdt.debug.gdbjtag.core.initCommands";
    private static final String ATTR_GDB_SET_STOP_AT = "org.eclipse.cdt.debug.gdbjtag.core.setStopAt";
    private static final String ATTR_GDB_STOP_AT = "org.eclipse.cdt.debug.gdbjtag.core.stopAt";
    private static final int SERVER_DEFAULT_PORT = 10000;

    private static int getGDBServerPort(String deviceCoreId) {
        DeviceCoreDescriptor descriptor = DeviceDescriptors.getDeviceRegistry().getDeviceCoreDescriptor(deviceCoreId);
        String debuggerId = DEBUGGER_ID;
        String serverPort = "";
        if (descriptor != null) {
            List configs = DebuggerDescriptors.getDeviceCoreDebuggerConfiguration((String)DEBUGGER_ID, (String)deviceCoreId);
            serverPort = !configs.isEmpty() ? ((Configuration)configs.get(0)).getPort() : DeviceCoreDebuggerDescriptors.getServerPort((String)deviceCoreId, (String)debuggerId);
        }
        if (serverPort.isEmpty()) {
            return 10000;
        }
        int result = 10000;
        try {
            result = Integer.valueOf(serverPort);
        }
        catch (NumberFormatException e) {
            VDKHardwareDebuggingLaunchConfigurationActivator.getInstance().log(VDKHardwareDebuggingLaunchConfigurationActivator.getInstance().createError("Cannot parse server port", e));
        }
        return result;
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String component;
        IResource launchResource;
        ILaunchConfigurationType debuggerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(JTAG_LAUNCH_CONFIGURATION_TYPE_ID);
        if (debuggerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(component = LaunchConfigurationUtil.extractComponent(attributes)) + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = debuggerLaunchType.newInstance((IContainer)container, component);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workConfig, Map<String, Object> attributes) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        workConfig.setMappedResources(new IResource[]{project});
        String buildArtifact = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        workConfig.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workConfig.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        String toolchainId = LaunchConfigurationUtil.extractHardwareToolchainId(attributes);
        String deviceCoreId = LaunchConfigurationUtil.extractHardwareDeviceCoreId(attributes);
        workConfig.setAttribute(ATTR_DSF_GDB_DEBUG_NAME, LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)DEBUGGER_ID, (String)toolchainId));
        workConfig.setAttribute(ATTR_GDB_JTAG_PORT_NUMBER, VDKHardwareDebuggingLaunchConfigurationCreator.getGDBServerPort(deviceCoreId));
        workConfig.setAttribute(ATTR_GDB_JTAG_DEVICE, GENERIC_TCP_IP);
        workConfig.setAttribute(ATTR_GDB_JTAG_IP_ADDRESS, LOCALHOST);
        workConfig.setAttribute(ATTR_GDB_DELAY, 3);
        workConfig.setAttribute(ATTR_GDB_INIT_COMMANDS, "set can-use-hw-watchpoints 0");
        workConfig.setAttribute(ATTR_GDB_SET_STOP_AT, true);
        workConfig.setAttribute(ATTR_GDB_STOP_AT, "main");
    }
}

