/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.ModularFactory;
import com.nxp.s32ds.rcp.modular.Repository;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.util.NLS;

public final class RepositoryUtils {
    private static final String ZIP = ".zip";
    private static final String JAR = ".jar";
    public static final String STUB_TXT = "stub.txt";
    public static final String STUB_COM = "stub.com";
    public static final String FILE_SCHEME = "file";
    public static final String REPOSITORIES_SPLITER = " repo ";

    private RepositoryUtils() {
    }

    public static IStatus checkRepositoryLocationSyntax(URI location) {
        if (location == null) {
            return ModularInstallerActivator.getInstance().createError(ModularMessages.Repository_Utils_NullLocationErrorMesssage);
        }
        if (!location.isAbsolute()) {
            return ModularInstallerActivator.getInstance().createError(ModularMessages.Repository_Utils_LocationMustBeAbsolute);
        }
        try {
            new URL(location.getScheme(), STUB_COM, -1, STUB_TXT);
        }
        catch (MalformedURLException malformedURLException) {
            return ModularInstallerActivator.getInstance().createError(ModularMessages.Repository_Utils_SchemeNotSupported);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateReposLocation(URI location) {
        String locationString;
        if (location == null) {
            return new Status(4, "com.nxp.s32ds.rcp.modular.core", ModularMessages.Repository_Utils_NullLocationErrorMesssage);
        }
        IStatus localValidationStatus = RepositoryUtils.checkRepositoryLocationSyntax(location);
        if (!(localValidationStatus.isOK() || (locationString = URIUtil.toUnencodedString((URI)location)).length() <= 0 || locationString.charAt(0) != '/' && locationString.charAt(0) != File.separatorChar)) {
            location = RepositoryUtils.localRepoURIFixer(location);
            localValidationStatus = RepositoryUtils.checkRepositoryLocationSyntax(location);
        }
        if (!localValidationStatus.isOK()) {
            return localValidationStatus;
        }
        return Status.OK_STATUS;
    }

    public static String makeLocalURIString(String path) {
        try {
            URI localURI = URIUtil.fromString((String)path);
            return URIUtil.toUnencodedString((URI)RepositoryUtils.localRepoURIFixer(localURI));
        }
        catch (URISyntaxException uRISyntaxException) {
            return path;
        }
    }

    public static URI localRepoURIFixer(URI location) {
        if (location == null) {
            return null;
        }
        if (location.getScheme() == null) {
            location = new File(location.getPath()).getAbsoluteFile().toURI();
        } else if (location.getScheme().length() == 1) {
            location = new File(URIUtil.toUnencodedString((URI)location)).toURI();
        } else if (!FILE_SCHEME.equalsIgnoreCase(location.getScheme())) {
            return location;
        }
        String lowerCase = location.toString().toLowerCase();
        if (lowerCase.endsWith(JAR) || lowerCase.endsWith(ZIP)) {
            return URIUtil.toJarURI((URI)location, null);
        }
        return location;
    }

    public static IStatus getInvalidStatus(String locationText) {
        return ModularInstallerActivator.getInstance().createError(NLS.bind((String)ModularMessages.Repository_Utils_InvalidLocation, (Object)locationText));
    }

    public static URI locationFromString(String trim) {
        URI userLocation;
        try {
            userLocation = URIUtil.fromString((String)trim);
        }
        catch (URISyntaxException e) {
            ModularInstallerActivator.getInstance().logError("String can't be formed into a valid URI", e);
            return null;
        }
        String uriString = URIUtil.toUnencodedString((URI)userLocation);
        if (uriString.length() > 0 && (uriString.charAt(0) == '/' || uriString.charAt(0) == File.separatorChar)) {
            return RepositoryUtils.localRepoURIFixer(userLocation);
        }
        return userLocation;
    }

    public static void readRepo(String pref, Collection<Repository> repositories) {
        String[] reposAsString;
        if (pref == null) {
            return;
        }
        String[] stringArray = reposAsString = pref.split(REPOSITORIES_SPLITER);
        int n = reposAsString.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String[] nameAndLocation = string.split(" ! ");
            if (nameAndLocation.length == 2) {
                String name = nameAndLocation[0];
                String location = nameAndLocation[1].trim();
                try {
                    Repository createRepository = ModularFactory.FACTORY.createRepository(name, new URI(location));
                    repositories.add(createRepository);
                }
                catch (URISyntaxException e) {
                    ModularInstallerActivator.getInstance().logError("URI violates RFC 2396 " + location, e);
                }
            }
            ++n2;
        }
    }
}

