/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.validation;

import com.nxp.swtools.common.uct.utils.CustomContextMenu;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.validation.IProblemUIContainer;
import com.nxp.swtools.common.uct.validation.ITextFieldValidator;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.ArrayList;
import java.util.logging.Logger;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import org.eclipse.core.runtime.Status;

public abstract class AValidatedTextField
extends TextField
implements IProblemUIContainer,
IProblemSource {
    protected static final Logger LOGGER = LogManager.getLogger(AValidatedTextField.class);
    protected ArrayList<ITextFieldValidator> validators = new ArrayList();
    public Status validationStatus;
    protected CustomContextMenu menu;
    protected boolean formatValid = true;
    private String pluginID = "";

    public AValidatedTextField(String pluginID) {
        this.validationStatus = new Status(0, pluginID, "");
        this.pluginID = pluginID;
        this.menu = new CustomContextMenu(this);
        this.setContextMenu(this.menu);
        this.menu.setAutoHide(true);
        this.setOnMouseClicked(e -> {
            if (!this.isEditable()) {
                this.menu.hide();
            } else if (!this.menu.isShowing() && e.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.menu.show(this.getScene().getWindow());
            }
        });
        this.setOnContextMenuRequested(e -> {
            if (!this.isEditable()) {
                this.menu.hide();
            }
        });
    }

    public AValidatedTextField(Runnable modelUpdater, String pluginID) {
        this(pluginID);
        this.setOnKeyReleased(e -> {
            if ((e.isControlDown() || e.getCode().getName().equalsIgnoreCase("ctrl")) && !e.getCode().getName().equalsIgnoreCase("x") && !e.getCode().getName().equalsIgnoreCase("v")) {
                e.consume();
            } else if (!e.getCode().getName().equalsIgnoreCase("enter")) {
                modelUpdater.run();
            }
        });
        this.menu.getPasteItem().setOnAction(e -> {
            this.paste();
            modelUpdater.run();
        });
    }

    public boolean isValid() {
        this.validateTextfield();
        return this.validationStatus.getSeverity() == 0;
    }

    public void validateTextfield() {
        String value = this.textProperty().getValue();
        assert (value != null) : "Textfield value is null";
        for (ITextFieldValidator validator : this.validators) {
            this.validationStatus = validator.validate(this.pluginID, value);
            this.setFormatValid(validator.isFormatValid());
            if (this.validationStatus.getSeverity() != 0) break;
        }
    }

    public void addValidator(ITextFieldValidator validator) {
        this.validators.add(validator);
    }

    public ArrayList<ITextFieldValidator> getValidators() {
        return this.validators;
    }

    public void resetStyle() {
        super.getStyleClass().clear();
        super.getStyleClass().add((Object)"text-input");
        super.getStyleClass().add((Object)"text-field");
    }

    public void setDefaultStyle() {
        super.getStyleClass().add((Object)"defaultRegisterField");
    }

    public void setResetStyle() {
        super.getStyleClass().add((Object)"changedRegisterField");
    }

    public void setFormatValid(boolean formatValid) {
        this.formatValid = formatValid;
    }

    public boolean isFormatValid() {
        return this.formatValid;
    }

    public void selectAll() {
        if (this.isEditable()) {
            super.selectAll();
        }
    }

    @Override
    public @Nullable String getInvalidFieldValue() {
        return (String)this.textProperty().get();
    }
}

