/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch;

import com.nxp.s32ds.cdt.svd.dsf.SvdDsfSessionCacheListener;
import com.nxp.s32ds.cdt.svd.dsf.SvdDsfSessionCacheManager;
import com.nxp.s32ds.cdt.svd.dsf.SvdDsfSessionListenerCache;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdRegistersViewBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInput;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdContextReadOnDemandAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdContextSetReadAlwaysAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdContextSetReadOnDemandAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdRegistersExportAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdRegistersImportAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdRemoveAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdShowFullPathAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdMementoWatchLoader;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdUiWatchModelCacheManager;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdWatchTreeViewer;
import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdCompositeModel;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdDeviceModel;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdCompositeWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelChangeEvent;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelChangeListener;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import com.nxp.s32ds.cle.ide.debugger.svd.launch.SvdLaunchConfigurations;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class SvdPeripheralRegistersWatchView
extends SvdRegistersViewBase
implements IDebugEventSetListener {
    public static final String ID = "com.nxp.s32ds.cdt.svd.ui.SvdPeripheralRegistersWatchView";
    public static final String REMOVE_ACTION = ActionFactory.DELETE.getId();
    public static final String SHOW_FULL_PATH_ACTION = "SHOW_FULL_PATH_ACTION";
    public static final String IMPORT_ACTION = "IMPORT_ACTION";
    public static final String EXPORT_ACTION = "EXPORT_ACTION";
    public static final String SET_READ_ONCE_ACTION = "SET_READ_ONCE_ACTION";
    public static final String SET_READ_ALWAYS_ACTION = "SET_READ_ALWAYS_ACTION";
    public static final String READ_ONCE_ACTION = "READ_ONCE_ACTION";
    private final SvdDsfSessionListenerCache listenerCache = new SvdDsfSessionListenerCache();
    private SvdChildElement toSelect;
    private SvdWatchModelChangeListener modelChangeListener = e -> this.modelChanged(e);
    private SvdDsfSessionCacheListener sessionCacheListener = e -> this.cacheChanged(e);

    @Override
    public SvdWatchTreeViewer getTreeViewer() {
        return (SvdWatchTreeViewer)super.getTreeViewer();
    }

    public SvdPeripheralRegistersWatchView() {
        SvdUiWatchModelCacheManager.getInstance().addListener(this.modelChangeListener);
        SvdDsfSessionCacheManager.getInstance().addCacheListener(this.sessionCacheListener);
    }

    @Override
    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        SvdUiWatchModelCacheManager.getInstance().removeListener(this.modelChangeListener);
        SvdDsfSessionCacheManager.getInstance().removeCacheListener(this.sessionCacheListener);
        this.listenerCache.dispose();
        super.dispose();
    }

    private void cacheChanged(SvdDsfSessionCacheListener.CacheEvent e) {
        Optional<DsfSession> opt = this.getTreeViewer().getDsfSession();
        if (!opt.isPresent() || !opt.get().equals((Object)e.session)) {
            return;
        }
        switch (e.type) {
            case CACHE_CHANGED: {
                Display.getDefault().asyncExec(() -> {
                    if (this.getTreeViewer() != null && !this.getTreeViewer().getTree().isDisposed()) {
                        SvdTrace.trace((String)"cacheChanged() - treeViewer.refresh() {}", (Object[])new Object[0]);
                        this.getTreeViewer().refresh();
                    }
                });
                break;
            }
        }
    }

    @Override
    protected Viewer createViewer(Composite parent) {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        return super.createViewer(parent);
    }

    @Override
    protected SvdTreeViewer createSvdViewer(Composite parent) {
        String id = this.getSite().getId();
        return new SvdWatchTreeViewer(parent, id);
    }

    @Override
    protected void setInput(SvdTreeViewerInput input) {
        super.setInput(input);
        if (input == null) {
            return;
        }
        DsfSession session = input.launch.getSession();
        this.listenerCache.addListener(session);
    }

    @Override
    protected void createActions() {
        super.createActions();
        SvdWatchTreeViewer treeViewer = this.getTreeViewer();
        this.setAction(REMOVE_ACTION, (IAction)new SvdRemoveAction(treeViewer));
        this.setAction(SHOW_FULL_PATH_ACTION, (IAction)new SvdShowFullPathAction(treeViewer));
        this.setAction(IMPORT_ACTION, (IAction)new SvdRegistersImportAction(treeViewer));
        this.setAction(EXPORT_ACTION, (IAction)new SvdRegistersExportAction(treeViewer));
        this.setAction(SET_READ_ALWAYS_ACTION, (IAction)new SvdContextSetReadAlwaysAction(treeViewer));
        this.setAction(SET_READ_ONCE_ACTION, (IAction)new SvdContextSetReadOnDemandAction(treeViewer));
        this.setAction(READ_ONCE_ACTION, (IAction)new SvdContextReadOnDemandAction(treeViewer));
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(REMOVE_ACTION, this.getAction(REMOVE_ACTION));
    }

    @Override
    protected void configureToolBar(IToolBarManager toolBarManager) {
        super.configureToolBar(toolBarManager);
        toolBarManager.add(this.getAction(IMPORT_ACTION));
        toolBarManager.add(this.getAction(EXPORT_ACTION));
    }

    @Override
    protected void configureToolBarMenu(IMenuManager menuManager) {
        super.configureToolBarMenu(menuManager);
        menuManager.add(this.getAction(SHOW_FULL_PATH_ACTION));
    }

    @Override
    protected List<Object> getActionsOrContributions() {
        List<Object> actionsOrContributions = super.getActionsOrContributions();
        actionsOrContributions.add(this.getAction(REMOVE_ACTION));
        actionsOrContributions.add(new Separator());
        actionsOrContributions.add(this.getAction(IMPORT_ACTION));
        actionsOrContributions.add(this.getAction(EXPORT_ACTION));
        actionsOrContributions.add(new Separator());
        actionsOrContributions.add(this.getAction(SET_READ_ALWAYS_ACTION));
        actionsOrContributions.add(this.getAction(SET_READ_ONCE_ACTION));
        actionsOrContributions.add(this.getAction(READ_ONCE_ACTION));
        return actionsOrContributions;
    }

    private void modelChanged(SvdWatchModelChangeEvent event) {
        if (this.getTreeViewer() == null || this.getTreeViewer().getInput() == null) {
            return;
        }
        SvdTreeViewerInput input = this.getTreeViewer().getInput();
        boolean present = ((SvdCompositeWatchModel)input.model).getModels().stream().filter(m -> m.equals((Object)event.getModel())).findAny().isPresent();
        if (!present) {
            return;
        }
        switch (event.getFlag()) {
            case 1: {
                this.handleAdd(event.getElements());
                break;
            }
            case 2: {
                this.handleBeforeRemove(event.getElements());
                break;
            }
            case 3: {
                this.handleRemove(event.getElements());
                break;
            }
            case 4: {
                this.handleChange(event.getElements());
                break;
            }
        }
    }

    private void handleBeforeRemove(Collection<SvdChildElement> elements) {
        if (elements.size() == 0) {
            return;
        }
        this.toSelect = this.getTreeViewer().findNextToSelect(elements);
    }

    private void handleRemove(Collection<SvdChildElement> elements) {
        if (elements.size() == 0) {
            return;
        }
        Collection registers = elements.stream().filter(e -> e instanceof SvdRegister).map(e -> (SvdRegister)e).collect(Collectors.toList());
        SvdTreeViewerInputs.removeRegisters(this.getTreeViewer(), registers);
        Display.getDefault().asyncExec(() -> {
            this.getTreeViewer().refresh();
            if (this.toSelect != null) {
                this.getTreeViewer().select(this.toSelect);
            } else {
                TreeItem[] items = this.getTreeViewer().getTree().getItems();
                if (items.length > 0) {
                    this.getTreeViewer().select(items[0].getData());
                }
            }
        });
    }

    private void handleChange(Collection<SvdChildElement> elements) {
        Display.getDefault().asyncExec(() -> this.getTreeViewer().refresh());
    }

    private void handleAdd(Collection<SvdChildElement> elements) {
        if (elements.size() == 0) {
            return;
        }
        List<SvdRegister> registers = elements.stream().filter(e -> e instanceof SvdRegister).map(e -> (SvdRegister)e).collect(Collectors.toList());
        SvdTreeViewerInputs.addRegisters(this.getTreeViewer(), registers);
        Display.getDefault().asyncExec(() -> this.getTreeViewer().expandAndSelect((SvdChildElement)elements.iterator().next()));
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (source instanceof RuntimeProcess && ((RuntimeProcess)source).getLaunch() == this.getCurrentLaunch() && event.getKind() == 4) {
                SvdTrace.trace((String)"refresh after create", (Object[])new Object[0]);
                Display.getDefault().asyncExec(() -> this.getTreeViewer().refresh());
            }
            ++n2;
        }
    }

    @Override
    protected EnumSet<SvdSourceType> getSuportedSvdSourceTypes() {
        return EnumSet.allOf(SvdSourceType.class);
    }

    @Override
    protected CompletableFuture<SvdCompositeModel<?>> createCompositeModelFuture(GdbLaunch launch) {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (SvdLaunchConfigurations.isCleanWatchView((ILaunchConfiguration)launchConfiguration)) {
            this.cleanWatchView(launchConfiguration);
        }
        return super.createCompositeModelFuture(launch);
    }

    private void cleanWatchView(ILaunchConfiguration launchConfiguration) {
        if (SvdLaunchConfigurations.isAskBeforeClean((ILaunchConfiguration)launchConfiguration)) {
            int[] result = new int[1];
            Shell shell = this.getSite().getShell();
            shell.getDisplay().syncExec(() -> {
                MessageDialog dialog = new MessageDialog(shell, Messages.SvdPeripheralRegistersWatchView_svd_support, null, NLS.bind((String)Messages.SvdPeripheralRegistersWatchView_do_you_really_want_to_clear_the_watch_registers_view_for_0_launch, (Object)launchConfiguration.getName()), 3, 1, new String[]{Messages.SvdPeripheralRegistersWatchView_clear_label, Messages.SvdPeripheralRegistersWatchView_dont_clear_label});
                nArray[0] = dialog.open();
            });
            if (result[0] != 0) {
                return;
            }
        }
        EnumSet<SvdSourceType> set = this.getSuportedSvdSourceTypes();
        SvdLaunchConfigurations.getSvdSources((ILaunchConfiguration)launchConfiguration).stream().filter(s -> set.contains(s.getType())).forEach(s -> SvdMementoWatchLoader.getInstance().clear(s.getUID()));
    }

    protected SvdCompositeModel<SvdWatchModel> createModel(DsfSession dsfSession, Collection<SvdDeviceModel> models) {
        List watchModels = models.stream().map(m -> SvdPeripheralRegistersWatchView.getModel(dsfSession, m)).filter(Objects::nonNull).collect(Collectors.toList());
        return new SvdCompositeWatchModel(watchModels);
    }

    private static SvdWatchModel getModel(DsfSession dsfSession, SvdDeviceModel m) {
        try {
            return SvdUiWatchModelCacheManager.getInstance().computeIfAbsent(dsfSession, (SvdContainer)m);
        }
        catch (DsfSessionInactiveException dsfSessionInactiveException) {
            return null;
        }
    }
}

