/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.provider;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProviders;
import com.nxp.s32ds.cdt.svd.model.SvdCluster;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheral;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheralGroup;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SvdColumnLabelPeripheralsProviders {
    public static SvdColumnLabelProvider<?>[] getProviders() {
        return new SvdColumnLabelProvider[]{new SvdPeripheralGroupLabelProvider(), new SvdPeripheralLabelProvider(), new SvdClusterLabelProvider(), new SvdRegisterLabelProvider(), new SvdFieldLabelProvider()};
    }

    public static class SvdClusterLabelProvider
    extends SvdColumnLabelProvider<SvdCluster> {
        public SvdClusterLabelProvider() {
            super(SvdCluster.class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, g -> g.getName());
        }

        public Image getImage(Object obj) {
            return CdtSvdUiActivator.getInstance().getImage("IMG_CLUSTER");
        }
    }

    public static class SvdFieldLabelProvider
    extends SvdFieldLabelProviderBase<SvdField> {
        public SvdFieldLabelProvider() {
            super(SvdField.class);
        }
    }

    public static class SvdFieldLabelProviderBase<T extends SvdField>
    extends SvdColumnLabelProvider<T> {
        public SvdFieldLabelProviderBase(Class<T> _class) {
            super(_class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, f -> this.getFieldLabel(f));
        }

        public Image getImage(Object obj) {
            return CdtSvdUiActivator.getInstance().getImage("IMG_FIELD");
        }

        public String getFieldLabel(T field) {
            if (field.getBitLength() == 1) {
                return NLS.bind((String)"{0} (bit {1})", (Object)field.getName(), (Object)field.getBitOffset());
            }
            return NLS.bind((String)"{0} (bits {1}-{2})", (Object[])new Object[]{field.getName(), field.getBitOffset(), field.getBitOffset() + field.getBitLength() - 1});
        }

        public String getToolTipText(Object element) {
            return this.apply(element, f -> String.join((CharSequence)", ", f.getName(), f.getDescription(), SvdColumnLabelProviders.getExplanation(f.getAccessType())));
        }
    }

    public static class SvdPeripheralGroupLabelProvider
    extends SvdColumnLabelProvider<SvdPeripheralGroup> {
        public SvdPeripheralGroupLabelProvider() {
            super(SvdPeripheralGroup.class);
        }

        @Override
        public String getText(Object element) {
            String name = this.apply(element, g -> g.getName());
            if (name == null) {
                return Messages.SvdModelGroupContentProvider_default_name;
            }
            return name;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
    }

    public static class SvdPeripheralLabelProvider
    extends SvdColumnLabelProvider<SvdPeripheral> {
        public SvdPeripheralLabelProvider() {
            super(SvdPeripheral.class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, g -> g.getName());
        }

        public Image getImage(Object obj) {
            return CdtSvdUiActivator.getInstance().getImage("IMG_PERIPHERAL");
        }
    }

    public static class SvdRegisterLabelProvider
    extends SvdRegisterLabelProviderBase<SvdRegister> {
        public SvdRegisterLabelProvider() {
            super(SvdRegister.class);
        }
    }

    public static class SvdRegisterLabelProviderBase<T extends SvdRegister>
    extends SvdColumnLabelProvider<T> {
        public SvdRegisterLabelProviderBase(Class<T> _class) {
            super(_class);
        }

        @Override
        public String getText(Object element) {
            return this.apply(element, r -> r.getName());
        }

        public Image getImage(Object obj) {
            return CdtSvdUiActivator.getInstance().getImage("IMG_REGISTER");
        }

        public String getToolTipText(Object element) {
            return this.apply(element, r -> String.join((CharSequence)", ", r.getName(), r.getDescription(), SvdColumnLabelProviders.getExplanation(r.getAccessType())));
        }
    }
}

