/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.ui.wizards.examples;

import com.nxp.s32ds.cle.ide.example.core.ExampleProjectFacade;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.ExamplesActivator;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExampleLabelProvider;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesContentProvider;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesHardwareFilter;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesNameFilter;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.HardwareTreeSelectionDialog;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.Messages;
import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.ide.examples.core.IExampleObject;
import com.nxp.s32ds.ext.ide.examples.core.IVisualComponent;
import java.util.ArrayList;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ExamplesViewer {
    private static final int VIEW_WIDTH = 800;
    private static final int VIEW_HEIGHT = 500;
    private TreeViewer treeView;
    private ExamplesNameFilter nameFilter;
    private ExamplesHardwareFilter hwFilter;
    private boolean folderSelected = false;
    private Composite composite;
    private IExampleComponent exmComponent;

    public ExamplesViewer(final Composite parent, final ExampleProjectFacade projetFacade) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(4, false));
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.heightHint = 500;
        layoutData.widthHint = 800;
        parent.setLayoutData((Object)layoutData);
        Label lblText = new Label(this.composite, 0);
        lblText.setText(Messages.Project_name);
        GridData gdlblText = new GridData(4, 4, false, false, 2, 1);
        gdlblText.heightHint = 20;
        lblText.setLayoutData((Object)gdlblText);
        final Text name = new Text(this.composite, 526336);
        name.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        name.setEditable(false);
        name.addModifyListener(e -> this.nameChanged(name.getText()));
        GridData gdFilter = new GridData(4, 4, true, false, 3, 1);
        gdFilter.heightHint = 15;
        final Text searchField = new Text(this.composite, 2048);
        searchField.setLayoutData((Object)gdFilter);
        searchField.setMessage(Messages.Enter_search_text);
        searchField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ExamplesViewer.this.nameFilter.setSearchText(searchField.getText());
                ExamplesViewer.this.treeView.refresh();
                ExamplesViewer.this.treeView.expandAll();
            }
        });
        Button btnHwFilter = new Button(this.composite, 8);
        btnHwFilter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        btnHwFilter.setImage(ExamplesActivator.getInstance().getImage("EXAMPLE_VIEW_FILTER_ICON"));
        btnHwFilter.setToolTipText(Messages.Hardware_filter);
        SashForm center = new SashForm(this.composite, 256);
        GridData ldCenter = new GridData(4, 4, true, true, 4, 1);
        center.setLayoutData((Object)ldCenter);
        Composite topPart = ExamplesViewer.createComoposite((Composite)center);
        Composite bottomPart = ExamplesViewer.createComoposite((Composite)center);
        Label lblTile = new Label(topPart, 0);
        lblTile.setText(Messages.Examples);
        this.treeView = new TreeViewer(topPart, 67584);
        this.treeView.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeView.setContentProvider((IContentProvider)new ExamplesContentProvider());
        this.treeView.setLabelProvider((IBaseLabelProvider)new ExampleLabelProvider());
        this.treeView.setInput((Object)projetFacade.convertToTreeVisualComponents());
        Label lblDecription = new Label(bottomPart, 0);
        lblDecription.setText(Messages.Description);
        final StyledText description = new StyledText(bottomPart, 2882);
        btnHwFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HardwareTreeSelectionDialog hwFilterDialog = new HardwareTreeSelectionDialog(parent.getShell(), projetFacade.getHardwareData(), ExamplesViewer.this.hwFilter.getDevices(), ExamplesViewer.this.hwFilter.getCores(), projetFacade.getHardwareCoresData(), Messages.Hardware_filter);
                if (hwFilterDialog.open() != 0) {
                    return;
                }
                ExamplesViewer.this.hwFilter.setDevices(hwFilterDialog.getResult());
                ExamplesViewer.this.hwFilter.setCores(hwFilterDialog.getResultCore());
                ExamplesViewer.this.clearSelection(name, description);
                ExamplesViewer.this.treeView.refresh();
                ExamplesViewer.this.treeView.expandAll();
            }
        });
        description.setAlwaysShowScrollBars(false);
        description.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)description);
        this.treeView.addSelectionChangedListener(e -> {
            Object selection = ExamplesViewer.getSelection(e.getSelection());
            if (selection instanceof IExampleObject) {
                this.folderSelected = false;
                IExampleObject exampleObject = (IExampleObject)selection;
                this.exmComponent = exampleObject.getModelingComponent();
                description.setText(this.exmComponent.getDescription() == null ? "" : this.exmComponent.getDescription());
                if (exampleObject.hasChilds()) {
                    IPath location = new Path(this.exmComponent.getLocation()).removeLastSegments(2);
                    ArrayList<IProjectDescription> projectList = new ArrayList<IProjectDescription>();
                    projectList.addAll(exampleObject.getRelatedProjectsDescriptors());
                    projectList.add(exampleObject.getProjectDescription());
                    ProjectSet projects = new ProjectSet(this.exmComponent.getId(), this.exmComponent.getDescription(), location, projectList);
                    this.projectSelected(projects);
                } else {
                    this.projectSelected(new ProjectSet(exampleObject.getProjectDescription()));
                }
                name.setText(this.exmComponent.getId() == null ? "" : this.exmComponent.getId());
                name.setEditable(true);
            }
            if (selection instanceof IVisualComponent) {
                this.folderSelected = true;
                this.clearSelection(name, description);
                this.folderSelected();
                return;
            }
            if (selection instanceof String && Messages.Examples_empty_list.equals(selection)) {
                this.clearSelection(name, description);
                return;
            }
        });
        this.nameFilter = new ExamplesNameFilter();
        this.hwFilter = new ExamplesHardwareFilter(projetFacade.getHardwareDevicesData(), projetFacade.getHardwareCoresData());
        this.treeView.setFilters(new ViewerFilter[]{this.nameFilter, this.hwFilter});
        searchField.setFocus();
    }

    private void clearSelection(Text name, StyledText description) {
        description.setText("");
        name.setEditable(false);
        name.setText("");
    }

    public static Composite createComoposite(Composite cmps) {
        return new Composite(cmps, 2048){
            {
                this.setLayout((Layout)new GridLayout(1, false));
            }
        };
    }

    public TreeViewer getTreeView() {
        return this.treeView;
    }

    protected abstract void projectSelected(ProjectSet var1);

    protected abstract void nameChanged(String var1);

    protected abstract void folderSelected();

    private static Object getSelection(ISelection selection) {
        return selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
    }

    public boolean isFolderSelected() {
        return this.folderSelected;
    }

    public Control getControl() {
        return this.composite;
    }

    public IExampleComponent getExampleComponent() {
        return this.exmComponent;
    }
}

