#!/bin/bash

BOARD=DGNOBOARD
BUILD_ORIG="Y"
BUILD_TEST="Y"
DEJA_ORIG="Y"
DEJA_TEST="Y"
SOURCE=FCtrunk
JOB=NLpower7
while [ $# -ne 0 ]; do
    a=$1
    shift
    case $a in
	-h)
	    cat <<EOF
Usage:
    regtest.sh [<options>] "list of patches"

Where <options> is zero or more of:
    -h                Prints this help and exit
    -skip-build-orig
    -skip-built-test
    -skip-deja-orig
    -skip-deja-test
    -skip-build
    -skip-deja
    -skip-orig
    -skip-test
    -T                Passes this options to dejagnu
    -glibc            Will test with built glibc instead of system libraries
EOF
	    exit 0
	    ;;
	-skip-build-orig)
	    BUILD_ORIG="N"
	    ;;
	-skip-build-test)
	    BUILD_TEST="N"
	    ;;
	-skip-deja-orig)
	    DEJA_ORIG="N"
	    ;;
	-skip-deja-test)
	    DEJA_TEST="N"
	    ;;
	-skip-build)
	    BUILD_ORIG="N"
	    BUILD_TEST="N"
	    ;;
	-skip-deja)
	    DEJA_ORIG="N"
	    DEJA_TEST="N"
	    ;;
	-skip-orig)
	    BUILD_ORIG="N"
	    DEJA_ORIG="N"
	    ;;
	-skip-test)
	    BUILD_TEST="N"
	    DEJA_TEST="N"
	    ;;
        -T=*)
            DEJA="T=\"${a:3}\""
	    ;;
        -glibc)
            BOARD="DGNAT"
	    ;;
	FCtrunk|FC47|FC46|FC45)
	    SOURCE=$a
	    ;;
	NLpower7|Npower7|N603e|NL603e|Ne500mc|NLe500mc)
	    JOB=$a
	    ;;
        *)  TESTPATCH=$a
	    ;;

    esac
done

mkdir -p build_gcc_orig build_gcc_test

# Original build
# ==============
TDY=`date +%Y%m%d`
if [ "$BUILD_ORIG" = "Y" ]; then
    cd build_gcc_orig
    build.sh s=$SOURCE $JOB
    cd ../
fi

# Test build
# ==========
NOW=`date +%Y%m%d`
if [ "$BUILD_TEST" = "Y" ]; then
    if [ "$TDY" != "$NOW" ]; then
        # Make sure the test build uses the same sources as the original build
	cp -r gcc-$TDY gcc-$NOW
    fi
    cd build_gcc_test
    build.sh s=$SOURCE $TESTPATCH $JOB
    cd ../
fi

# Original dejagnu
# ================
if [ "$DEJA_ORIG" = "Y" ]; then
    cd build_gcc_orig
    build.sh s=$SOURCE t=$BOARD $DEJA $JOB -s "Tgcc"
    cd ../
fi

# Test dejagnu
# ============
if [ "$DEJA_TEST" = "Y" ]; then
    cd build_gcc_test
    build.sh s=$SOURCE t=$BOARD $DEJA $JOB -s "Tgcc"
    cd ../
fi

# Compare dejagnu logs
check_dg.sh build_gcc_orig/$JOB/logs build_gcc_test/$JOB/logs > check_dg.log
