#!/bin/bash

# Arguments
REPO=$1
REV=$2
SRC=$3
JOB=$4
LOG=$5
DO_SPEC=$6

if [ "$REPO" = "" -o "$REV" = "" -o "$SRC" = "" -o "$JOB" = "" -o "$LOG" = "" -o "$DO_SPEC" = "" ]; then
    echo "Error on job submission REPO=$REPO REV=$REV SRC=$SRC JOB=$JOB LOG=$LOG DO_SPEC=$DO_SPEC"
    echo "Example:"
    echo "    submit_lsf.sh (REPO) (REV) (SRC) <job> <log> Y"
    exit 1
fi

# Make submission to LSF

bsub -q normal -P dn.sst.devtech.comp -R "select[rhel6] span[hosts=1]" -R "rusage[tmp=10000] && mem>4096" -n 8 -J $JOB $REPO/build_gnu/build_lsf.sh $REV $SRC $JOB $LOG $DO_SPEC
# Wait it to complete
while true; do
    sleep 30
    x=`bjobs | grep $JOB`
    if [ "$x" = "No unfinished job found" -o "$x" = "" ]; then
	# Either all jobs finished or this specific one has finished
	exit 0
    fi
done

