#!/bin/bash

prog=$1

SIM=~/dt-labhome/simulators/ame_4.0.1/x86_64-linux/bin/sim-ame
SIMCONFIG=z4

r1=`echo $RANDOM`
r2=`echo $RANDOM`
UniqueID=vle_tmp_${r1}_${r2}

# Execution
$SIM $SIMCONFIG $prog > $UniqueID 2>&1

# last 2 lines of simulation is:
# program exit(0)
# Sim. Loop Time: 0 Seconds; Clock Ticks: 1301; CPS 0.000

# This is the program output, show it on stdout
head -n -2 $UniqueID

# Get the exit status
x=`tail -n 2 $UniqueID | awk '{print substr($2,6,length($2)-6); exit}'`

# remove tmp files
rm -f $UniqueID

# Return the exit status
exit $x
