#!/bin/bash

JSDIR=/proj/ppc/DT/labhome/job_server

function gen_seqid () {
    SEQID=0
    [ -e $JSDIR/seqid ] && source $JSDIR/seqid
    let x=$SEQID+1
    let x=$x%10000
    echo "SEQID=$x" > $JSDIR/seqid
}

declare -A spec2k_tmo
spec2k_tmo=(
    ["gzip"]=600
    ["vpr"]=600
    ["crafty"]=600
    ["parser"]=600
    ["eon"]=800
    ["gap"]=600
    ["vortex"]=600
    ["twolf"]=600
    ["perlbmk"]=600
    ["perl"]=600
    ["wupwise"]=1200
    ["swim"]=3600
    ["mgrid"]=4800
    ["applu"]=3600
    ["mesa"]=600
    ["galgel"]=3600
    ["art"]=600
    ["equake"]=600
    ["facerec"]=2400
    ["ammp"]=4800
    ["lucas"]=1800
    ["fma3d"]=3600
    ["sixtrack"]=4800
    ["apsi"]=3600
    ["gcc"]=600
    ["mcf"]=600
    ["bzip2"]=600
)
declare -A spec2k6_tmo
spec2k6_tmo=(
    ["perlbench"]=3600
    ["perl"]=3600
    ["bwaves"]=7200
    ["gamess"]=7200
    ["milc"]=3600
    ["zeusmp"]=7200
    ["gromacs"]=10800
    ["cactusADM"]=10800
    ["leslie3d"]=7200
    ["namd"]=3600
    ["gobmk"]=3600
    ["dealII"]=3600
    ["soplex"]=3600
    ["povray"]=3600
    ["calculix"]=7200
    ["hmmer"]=3600
    ["sjeng"]=3600
    ["GemsFDTD"]=7200
    ["libquantum"]=7200
    ["h264ref"]=3600
    ["tonto"]=7200
    ["lbm"]=3600
    ["omnetpp"]=3600
    ["astar"]=3600
    ["wrf"]=7200
    ["sphinx3"]=7200
    ["xalancbmk"]=3600
    ["gcc"]=3600
    ["mcf"]=3600
    ["bzip2"]=3600
)

# Default arguments 
USR=`id -nu`
CMD=tar
TMO=1000
REP=3
TAG=$USR
KEEP="N"
VERBOSE="N"
CORE="no-core"

for arg in "$@"; do
    case $arg in
	-h)
	    cat <<EOF
Usage is:
    jsq.sh <machine>
        List queue of machine
    jsq.sh <machine> r=<job id ...>
        Remove jobs from queue
    jsq.sh <machine> P=<job id ...>
        Increase priority of jobs
    jsq.sh <machine> p=<job id ...>
        Lower priority of jobs
    jsq.sh <machine> [-k] -[v] [2k|2k6] x9 [<benchmark>] t=<sec> tag=<tag> e=<executable> core=<core> flgs=<flags>
        Submit job to queue
EOF
	    exit 0
	    ;;
	-keep|-k)
	    KEEP="Y"
	    ;;
	-v)
	    VERBOSE="Y"
	    ;;
	perf3farm*|perf3board*)
	    MACH=$arg
	    if [ ! -e $JSDIR/$MACH ]; then
		echo "This machine is not ready for job server work"; exit 1; fi
	    ;;
	r=*)
	    if [ "$MACH" = "" ]; then
                echo "Must specify machine before job id"; exit 1; fi
	    LJID=${arg:2}
	    for JID in $LJID; do
		if [ -e $JSDIR/$MACH/queue/$JID ]; then
	            # Remove job from queue
		    source $JSDIR/$MACH/queue/$JID
		    echo "Removing $JID"
		    rm -f $JSDIR/$MACH/queue/$JID
		    rm -f $JSEXE
		elif [ -e $JSDIR/$MACH/queuep/$JID ]; then
  	            # Remove job from queue
		    source $JSDIR/$MACH/queuep/$JID
		    echo "Removing $JID"
		    rm -f $JSDIR/$MACH/queuep/$JID
		    rm -f $JSEXE
		else
		    echo "Job Id does not exist: $JID"
		    exit 1
		fi
	    done
	    exit 0
	    ;;
	P=*)
	    if [ "$MACH" = "" ]; then
                echo "Must specify machine before job id"; exit 1; fi
	    LJID=${arg:2}
	    for JID in $LJID; do
		if [ -e $JSDIR/$MACH/queuep/$JID ]; then
		    echo "Increasing priority of $JID"
		    mv -f $JSDIR/$MACH/queuep/$JID $JSDIR/$MACH/queue/$JID
		fi
	    done
	    exit 0
	    ;;
	p=*)
	    if [ "$MACH" = "" ]; then
                echo "Must specify machine before job id"; exit 1; fi
	    LJID=${arg:2}
	    for JID in $LJID; do
		if [ -e $JSDIR/$MACH/queue/$JID ]; then
		    echo "Lowering priority of $JID"
		    mv -f $JSDIR/$MACH/queue/$JID $JSDIR/$MACH/queuep/$JID
		fi
	    done
	    exit 0
	    ;;
	2k|2k6)
	    CMD=$arg
	    ;;
	t=*)
	   let TMO=${arg:2}
	   if [ $TMO -le 0 ]; then
	       echo "Timeout must be positive number: $TMO"; exit 1; fi
	   ;;
	x=*)
	    let REP=${arg:2}
	    if [ $REP -le 0 -o $REP -gt 20 ]; then
		echo "Repetion must be number from 1 to 20: $REP"; exit 1; fi
	    ;;
	e=*)
	    EXE=${arg:2}
	    if [ ! -e $EXE ]; then
		echo "Could not find file: $EXE"; exit 1; fi
	    ;;
	tag=*)
	    TAG=${arg:4}
	    ;;
	core=*)
	    CORE=${arg:5}
	    ;;
	flgs=*)
	    FLGS=${arg:5}
	    ;;
	gzip|vpr|crafty|parser|eon|gap|vortex|twolf|perlbmk| \
        wupwise|swim|mgrid|applu|mesa|galgel|art|equake|facerec|ammp|lucas|fma3d|sixtrack|apsi)
	    # Unambigous spec2k benchmark name
	    if [ "$CMD" = "2k6" ]; then
		echo "Don't mix spec2k and spec2k6 benchmarks in the same invocation"
		exit 1
	    fi
	    let TMO=spec2k_tmo[$arg]*$REP
	    CMD="2k"
	    BMK="spec2k.$arg"
	    SUBBMK=$arg
	    ;;
	perlbench|bwaves|gamess|milc|zeusmp|gromacs|cactusADM|leslie3d|namd|gobmk|dealII| \
	soplex|povray|calculix|hmmer|sjeng|GemsFDTD|libquantum|h264ref|tonto| \
	lbm|omnetpp|astar|wrf|sphinx3|xalancbmk)
	    # Unambigous spec2k6 benchmark name
	    if [ "$CMD" = "2k" ]; then
		echo "Don't mix spec2k and spec2k6 benchmarks in the same invocation"
		exit 1
 	    fi
	    let TMO=spec2k6_tmo[$arg]*$REP
	    CMD="2k6"
	    BMK="spec2k6.$arg"
	    SUBBMK=$arg
	    ;;
	gcc|mcf|bzip2)
            # This can be either one, must rely on explicty command (2k or 2k6) to set type
	    if [ "$CMD" = "" ]; then
		echo "Need to specify {2k|2k6} before benchmark name"
		exit 1
	    elif [ "$CMD" = "2k" ]; then
		let TMO=spec2k_tmo[$arg]*$REP
		BMK="spec2k.$arg"
	    elif [ "$CMD" = "2k6" ]; then
		BMK="spec2k6.$arg"
		let TMO=spec2k6_tmo[$arg]*$REP
	    fi
	    SUBBMK=$arg
	    ;;
	perl)
            # This can be either one, must rely on explicty command (2k or 2k6) to set type
	    if [ "$CMD" = "" ]; then
		echo "Need to specify {2k|2k6} before benchmark name"
		exit 1
	    elif [ "$CMD" = "2k" ]; then
		BMK="spec2k.perlbmk"
		SUBBMK=perlbmk
		let TMO=spec2k_tmo[$arg]*$REP
	    elif [ "$CMD" = "2k6" ]; then
		BMK="spec2k.perlbench"
		SUBBMK=perlbench
		let TMO=spec2k6_tmo[$arg]*$REP
	    fi
	    ;;
	dhrystone|coremark)
	    TMO=30
	    CMD="tar"
	    BMK=$arg
	    SUBBMK=$arg
	    ;;
	nbench)
	    TMO=600
	    CMD="tar"
	    BMK=$arg
	    SUBBMK=$arg
	    ;;
	# auto-1
	a2time01|aifftr01|aifirf01|aiifft01|basefp01|bitmnp01|cacheb01|canrdr01| \
        idctrn01|iirflt01|matrix01|pntrch01|puwmod01|rspeed01|tblook01|ttsprk01| \
	a2time01_lite|aifftr01_lite|aifirf01_lite|aiifft01_lite|basefp01_lite|bitmnp01_lite|cacheb01_lite|canrdr01_lite| \
        idctrn01_lite|iirflt01_lite|matrix01_lite|pntrch01_lite|puwmod01_lite|rspeed01_lite|tblook01_lite|ttsprk01_lite)
	    TMO=180
	    CMD="tar"
	    BMK="auto-1.$arg"
	    SUBBMK=$arg
	    ;;
	# consumer-1
	cjpeg|djpeg|rgbcmy01|rgbhpg01|rgbyiq01| \
	cjpeg_lite|djpeg_lite|rgbcmy01_lite|rgbhpg01_lite|rgbyiq01_lite)
	    TMO=30
	    CMD="tar"
	    BMK="consumer-1.$arg"
	    SUBBMK=$arg
	    ;;
	# net-1 or net-2
	routelookup)
	    TMO=60
	    CMD="tar"
	    SUBBMK=$arg
	    x=`echo $EXE | grep net-1`
	    if [ "$x" != "" ]; then
		BMK="net-1.$arg"
	    else
		BMK="net-2.$arg"
	    fi
	    ;;
	# net-1
        ospf|pktflowb1m|pktflowb2m|pktflowb4m|pktflowb512k| \
        ospf_lite|pktflowb1m_lite|pktflowb2m_lite|pktflowb4m_lite|pktflowb512k_lite|routelookup_lite)
	    TMO=180
	    CMD="tar"
	    BMK="net-1.$arg"
	    SUBBMK=$arg
	    ;;
	# ofice-1
        dither01|rotate01|text01| \
        dither01_lite|rotate01_lite|text01_lite)
	    TMO=180
	    CMD="tar"
	    BMK="office-1.$arg"
	    SUBBMK=$arg
	    ;;
	# telecom-1
        autcor00data_1|conven00data_2|fbital00data_2|fft00data_2|viterb00data_3| \
        autcor00data_2|conven00data_3|fbital00data_3|fft00data_3|viterb00data_4| \
        autcor00data_3|fbital00data_6|viterb00data_1|conven00data_1| \
        fft00data_1|viterb00data_2| \
        autcor00data_1_lite|conven00data_2_lite|fbital00data_2_lite|fft00data_2_lite|viterb00data_3_lite| \
        autcor00data_2_lite|conven00data_3_lite|fbital00data_3_lite|fft00data_3_lite|viterb00data_4_lite| \
        autcor00data_3_lite|fbital00data_6_lite|viterb00data_1_lite|conven00data_1_lite| \
        fft00data_1_lite|viterb00data_2_lite)
	    TMO=180
	    CMD="tar"
	    BMK="telecom-1.$arg"
	    SUBBMK=$arg
	    ;;
	# net-2
        ip_pktcheckb4m|nat|tcpmixed|ip_pktcheckb1m| \
        ip_pktcheckb512k|ospfv2|tcpbulk|ip_pktcheckb2m|ip_reassembly|qos|tcpjumbo)
	    TMO=180
	    CMD="tar"
	    BMK="net-2.$arg"
	    SUBBMK=$arg
	    ;;
	# office-2
        bezierv2fixed_d2|textv2_d2|gs8_d2|ditherv2_d2| \
        bezierv2fixed_d3|textv2_d3|gs8_d3|ditherv2_d3| \
        bezierv2fixed_d4|textv2_d4|gs8_d4|ditherv2_d4| \
        ditherv2_d5|ditherv2_d6|ditherv2_d7|ditherv2_d8|ditherv2_d9|ditherv2_d10|ditherv2_d11)
	    TMO=180
	    CMD="tar"
	    BMK="office-2.$arg"
	    SUBBMK=$arg
	    ;;
        bezierv2float_d2|rotatev2_d2| \
        bezierv2float_d3|rotatev2_d3| \
        bezierv2float_d4|rotatev2_d4| \
        rotatev2_d5|rotatev2_d6|rotatev2_d7|rotatev2_d8|rotatev2_d9|rotatev2_d10|rotatev2_d11)
	    TMO=240
	    CMD="tar"
	    BMK="office-2.$arg"
	    SUBBMK=$arg
	    ;;
	# consumer-2
        mp2decodf32psnr1|mp2decodf32psnr2|mp2decodf32psnr3|mp2decodf32psnr4|mp2decodf32psnr5| \
        mp2decodfixpsnr1|mp2decodfixpsnr2|mp2decodfixpsnr3|mp2decodfixpsnr4|mp2decodfixpsnr5| \
        mp2decoddata1|mp2decoddata2|mp2decoddata3|mp2decoddata4|mp2decoddata5| \
        mp2enfixdata1|mp2enfixdata2|mp2enfixdata3|mp2enfixdata4|mp2enfixdata5| \
        mp4decodedata1|mp4decodedata2|mp4decodedata3|mp4decodedata4|mp4decodedata5| \
        mp4decodepsnr1|mp4decodepsnr2|mp4decodepsnr3|mp4decodepsnr4|mp4decodepsnr5| \
        mp4encodedata1|mp4encodedata2|mp4encodedata3|mp4encodedata4|mp4encodedata5| \
        mp3playerfixeddata1|mp3playerfixeddata2|mp3playerfixeddata3|mp3playerfixeddata4|mp3playerfixeddata5| \
        cjpegv2data1|cjpegv2data2|cjpegv2data3|cjpegv2data4|cjpegv2data5|cjpegv2data6|cjpegv2data7| \
        djpegv2data1|djpegv2data2|djpegv2data3|djpegv2data4|djpegv2data5|djpegv2data6|djpegv2data7| \
        rgbcmykv2data1|rgbcmykv2data2|rgbcmykv2data3|rgbcmykv2data4|rgbcmykv2data5|rgbcmykv2data6|rgbcmykv2data7| \
        rgbhpgv2data1|rgbhpgv2data2|rgbhpgv2data3|rgbhpgv2data4|rgbhpgv2data5|rgbhpgv2data6|rgbhpgv2data7| \
        rgbyiqv2data1|rgbyiqv2data2|rgbyiqv2data3|rgbyiqv2data4|rgbyiqv2data5|rgbyiqv2data6|rgbyiqv2data7| \
        aes|huffde)
	    TMO=500
	    CMD="tar"
	    BMK="consumer-2.$arg"
	    SUBBMK=$arg
	    ;;
	*)
	    echo "Unkown command: $arg"
	    ;;
    esac
done

# Check arguments
if [ "$MACH" = "" ]; then
    echo "No job server machine was specified"
    exit 1
fi
if [ "$CMD" != "tar" -a "$SUBBMK" = "" ]; then
    echo "Spec executables must have benchmark name specified"
    exit 1
fi

if [ "$EXE" = "" ]; then
    files=`ls -1rt $JSDIR/$MACH/queue`
    let acum=0
    echo "Job queue for $MACH"
    for f in $files; do
	source $JSDIR/$MACH/queue/$f
	if [ "$CMD" = "2k" -o "$CMD" = "2k6" ]; then
	    let acum+=$TMO
	else
	    let acum+=($TMO*$REP)
	fi
	let min=($acum/60)%60
	let hr=($acum/3600)%24
	let days=($acum/3600)/24
	echo -e "    $f\t ${days}d ${hr}h ${min}m\t TMO=$TMO  \t TAG=$TAG\t CORE=$CORE\t BMK=$BMK"
    done
    let min=($acum/60)%60
    let hr=($acum/3600)%24
    let days=($acum/3600)/24
    echo "Estimate total executuion time: ${days}d ${hr}h ${min}m"
    files=`ls -1rt $JSDIR/$MACH/queuep`
    for f in $files; do
	source $JSDIR/$MACH/queuep/$f
	if [ "$CMD" = "2k" -o "$CMD" = "2k6" ]; then
	    let acum+=$TMO
	else
	    let acum+=($TMO*$REP)
	fi
	let min=($acum/60)%60
	let hr=($acum/3600)%24
	let days=($acum/3600)/24
	echo -e "    $f\t ${days}d ${hr}h ${min}m\t TMO=$TMO  \t TAG=$TAG\t CORE=$CORE\t BMK=$BMK"
    done
    let min=($acum/60)%60
    let hr=($acum/3600)%24
    let days=($acum/3600)/24
    echo "Estimate total executuion time: ${days}d ${hr}h ${min}m"
else
    # New job to be queued
    gen_seqid
    fexe=`basename $EXE`
    JSEXE=$JSDIR/$MACH/binary/$fexe.$SEQID
    if [ $TMO -gt 600 ]; then
	# Put big jobs in low priority queue
	JSQUEUE=$JSDIR/$MACH/queuep/$USR.$SEQID
    else
	JSQUEUE=$JSDIR/$MACH/queue/$USR.$SEQID
    fi
    # Copy executable to binary dir
    cp -f $EXE $JSEXE
    # Create queue entry in queue dir
    echo "USR=$USR" > $JSQUEUE
    echo "REP=$REP" >> $JSQUEUE
    echo "TMO=$TMO" >> $JSQUEUE
    echo "CORE=$CORE" >> $JSQUEUE
    echo "BMK=$BMK" >> $JSQUEUE
    echo "SUBBMK=$SUBBMK" >> $JSQUEUE
    echo "CMD=$CMD" >> $JSQUEUE
    echo "TAG=$TAG" >> $JSQUEUE
    echo "EXE=$EXE" >> $JSQUEUE
    echo "JSEXE=$JSEXE" >> $JSQUEUE
    echo "KEEP=$KEEP" >> $JSQUEUE
    echo "FLGS=\"$FLGS\"" >> $JSQUEUE
    if [ "$VERBOSE" = "Y" ]; then
	echo "Job submitted as: $USR.$SEQID"
    else
	echo -n "."
    fi
fi

