#!/bin/bash

# Arguments are
# <install dir> <list of tar balls>

INSTALLLINKDIR="/_TOOLS_/dist/gnu_toolchain"
INSTALLDIR=$1
shift
INSTPREFIX=$1
shift

usage () {
    echo "Usage is: install_CDE <directory> <prefix> <list of tar balls>"
    echo "File name for tarball must have general format:"
    echo "    <prefix>-<host>-<date/revision>.tar.{gz|bz2|xz}"
}

if [ ! -d $INSTALLDIR ]; then
    usage
    exit 0
fi

for t in "$@"; do
    if [ ! -f $t ]; then
        echo "Cannot find file: $t"
        continue
    fi
    # Breakdown tarball file name, first with extension
    t1=`basename $t`
    t2=`basename $t1 .tar.gz`
    t3=`basename $t1 .tar.bz2`
    t4=`basename $t1 .tar.xz`
    tp=""
    if [ "$t2" != "$t1" ]; then
	# This is gzip
	TAR="xzf"
	tp=$t2
    elif [ "$t3" != "$t1" ]; then
	# This is bzip2
	TAR="xjf"
	tp=$t3
    elif [ "$t4" != "$t1" ]; then
	# This is xz
	TAR="xJf"
	tp=$t4
    else
	echo "I cannot process extension of this file: $t"
	continue
    fi

    echo "Processing:    $INSTPREFIX"

    echo "... Removing old install"
    cd $INSTALLDIR
    rm -rf $INSTPREFIX

    echo "... Expanding tarball"
    tar $TAR $t

    echo "... Creating link"
    rm -f $INSTALLLINKDIR/$INSTPREFIX
    pushd $INSTALLLINKDIR > /dev/null
    ln -s $INSTALLDIR/$INSTPREFIX $INSTPREFIX
    popd > /dev/null

    echo "Dpne"
done
