#!/bin/bash

list_bmks () {
    # Function to go through log files and find results marked with '=N'
    # Must also keep track of the <target>.<ml>
    local fname job tarball tools
    fname=$1

    cat WD_$fname/test.target_log | gawk '/^CORE=/ { core=substr($1,6) }  /=N/ { print "     ", core, "\t", gensub("BMK=","","g",$1) }'
}

list_exec () {
    # Function to find and extract command to reproduce a test
    local fname job tarball tools
    local cmd
    fname=$1

    job=`echo $fname | gawk '{ split($1,a,"_"); print gensub("L","","g",a[4]); exit }'`
    tarball=`cat ~/.release.log | grep 'Linux tarball' | grep $job | gawk '{print $4; exit}'`
    tools=`echo $tarball | gawk '{ split($1,a,"-"); printf ("%s-%s-%s-%s/%s-%s", a[1],a[2],a[3],a[4],a[5],a[6]); exit }'`

    cmd=`grep $fname ~/.release.log | grep '^  exec' | gawk '{$1=""; NF=NF-3; print gensub("<tools>",tools,"g",gensub("<tarname>",tarball,"g",$0)); exit}' tarball=$tarball tools=$tools `
    echo "Cmd: $cmd"
}

list_unsup () {
    # Function to find and extract number of unsupported test cases
    local fname limit
    fname=$1
    limit=$2

    cat $fname | gawk '/UNSUP/ { x1=index($0,"UNSUP")+5; n=strtonum(substr($0,x1)); if (n > limit) print fname,"  \t",$1,"\t UNSUP: ",n }' limit=$limit fname=$fname
}

list_unres () {
    # Function to find and extract number of unsupported test cases
    local fname limit
    fname=$1
    limit=$2

    cat $fname | gawk '/UNRES/ { x1=index($0,"UNRES")+5; n=strtonum(substr($0,x1)); if (n > limit) print fname,"  \t",$1,"\t UNRES: ",n }' limit=$limit fname=$fname
}

list_fail () {
    # Function to find and extract number of unsupported test cases
    local fname limit
    fname=$1
    limit=$2

    cat $fname | gawk '/FAIL/ { x1=index($0,"FAIL")+4; n=strtonum(substr($0,x1)); if (n > limit) print fname,"  \t",$1,"\t FAIL: ",n }' limit=$limit fname=$fname
}

# Default arguments
lim_unsup_E=4000
lim_unres_E=1000
lim_fail_E=1000
lim_unsup_X=4000
lim_unres_X=200
lim_fail_X=200
lim_unsup_N=4000
lim_unres_N=200
lim_fail_N=200
tgt="X"

print_usage () {
    echo "Usage is:"
    echo "   inspect_logs.sh [E|X|N] [unsup=<number>] [unres=<number>] [fail=<number] [E|X|N] ..."
    echo "Defaul arguments:"
    echo "   E unsup=4000 unres=1000 fail=1000 X unsup=4000 unres=200 fail=200 N unsup=4000 unres=200 fail=200"
    echo ""
}

# Parse arguments
while [ $# -ne 0 ]; do
    a=$1
    shift
    case $a in
	-h)
	    print_usage
	    exit 0
	    ;;
	E)
            tgt=$a
	    ;;
	X)
            tgt=$a
	    ;;
	N)
            tgt=$a
	    ;;
	unsup=*)
	    [ "$tgt" = "E" ] && lim_unsup_E=${a:6}
	    [ "$tgt" = "X" ] && lim_unsup_X=${a:6}
	    [ "$tgt" = "N" ] && lim_unsup_N=${a:6}
	    ;;
	unres=*)
	    [ "$tgt" = "E" ] && lim_unres_E=${a:6}
	    [ "$tgt" = "X" ] && lim_unres_X=${a:6}
	    [ "$tgt" = "N" ] && lim_unres_N=${a:6}
	    ;;
	fail=*)
	    [ "$tgt" = "E" ] && lim_fail_E=${a:5}
	    [ "$tgt" = "X" ] && lim_fail_X=${a:5}
	    [ "$tgt" = "N" ] && lim_fail_N=${a:5}
	    ;;
	*)
	    ;;
    esac
done

echo "Tests - Summary"
echo "==============="
grep FAIL release_*test_* | grep -v 'FAIL 0'; grep '..PASS' release_*test* | wc -l
echo ""

echo "Tests - Failures detailed"
echo "========================="
for f in release_*test_*; do
    x=`grep FAIL $f | grep -v 'FAIL 0'`
    if [ "$x" != "" ]; then
	echo "Fail: $f"
	list_bmks $f
	list_exec $f
	echo ""
    fi
done
echo ""

echo "Deja - Inspect copying of libs"
echo "=============================="
for f in release_*deja_*; do
    x=`grep '...Error' $f | grep -v 'Removing gcc libs and glibc sysroot' | grep -v 'Send list of files to be removed' `
    if [ "$x" != "" ]; then
	echo "Fail: $f"
    fi
done
echo ""

echo "Deja - Inspect UNSUP"
echo "===================="
for f in release_*deja_Fed_E*; do
    list_unsup $f $lim_unsup_E
done
for f in release_*deja_Fed_X*; do
    list_unsup $f $lim_unsup_X
done
for f in release_*deja_nat*; do
    list_unsup $f $lim_unsup_N
done
echo ""

echo "Deja - Inspect UNRES"
echo "===================="
for f in release_*deja_Fed_E*; do
    list_unres $f $lim_unres_E
done
for f in release_*deja_Fed_X*; do
    list_unres $f $lim_unres_X
done
for f in release_*deja_nat*; do
    list_unres $f $lim_unres_N
done
echo ""

echo "Deja - Inspect FAIL"
echo "==================="
for f in release_*deja_Fed_E*; do
    list_fail $f $lim_fail_E
done
for f in release_*deja_Fed_X*; do
    list_fail $f $lim_fail_X
done
for f in release_*deja_nat*; do
    list_fail $f $lim_fail_N
done
echo ""
