#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

cd $BD/tmp
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="autcor00data_1 conven00data_2 fbital00data_2 fft00data_2 viterb00data_3 \
           autcor00data_2 conven00data_3 fbital00data_3 fft00data_3 viterb00data_4 \
           autcor00data_3 fbital00data_6 viterb00data_1 conven00data_1 \
           fft00data_1 viterb00data_2"
else
    blist=$SUB
fi
for e in $blist; do
    sh -c "./${e}.exe -autogo > ${e}.log 2> ${e}.err" >> ${e}.err 2>&1
    let n=$?
    x=`cat ${e}.err`
    if [ $n = 0 -a "$x" = "" ]; then
	echo "BMK=telecom-1.${e} EXEC=Y" >> $TLOG
	P="$P $e"
    else
	echo "BMK=telecom-1.${e} EXEC=N" >> $TLOG
	F="$F $e"
    fi
    sh -c "./${e}_lite.exe > ${e}_lite.log 2> ${e}_lite.err" >> ${e}_lite.err 2>&1
    let n=$?
    x=`cat ${e}_lite.err`
    if [ $n = 0 -a "$x" = "" ]; then
	echo "BMK=telecom-1.${e}_lite EXEC=Y" >> $TLOG
	P="$P ${e}_lite"
    else
	echo "BMK=telecom-1.${e}_lite EXEC=N" >> $TLOG
	F="$F ${e}_lite"
    fi
done
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
