#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_stanford
if [ "$TGURU_C" = "" ]; then
    export TGURU_C=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
export TGURU_FLAGS_C="$FLGS $T_CFLAGS $T_LFLAGS"
rm -f stanford.exe
$TGURU_C $TGURU_FLAGS_C stanford.c -o stanford.exe -lm > stanford_build.$MLTYPE.out 2>&1
if [ -e stanford.exe ]; then
    # Compilation successful
    echo "BMK=stanford COMP=Y" >> $HLOG
    echo "..PASS"
else
    # Compilation failed
    echo "BMK=stanford COMP=N" >> $HLOG
    echo "..FAIL"
fi
