#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6

path2k6_bwaves="benchspec/CPU2006/410.bwaves/exe"
path2k6_gamess="benchspec/CPU2006/416.gamess/exe"
path2k6_milc="benchspec/CPU2006/433.milc/exe"
path2k6_zeusmp="benchspec/CPU2006/434.zeusmp/exe"
path2k6_gromacs="benchspec/CPU2006/435.gromacs/exe"
path2k6_cactusADM="benchspec/CPU2006/436.cactusADM/exe"
path2k6_leslie3d="benchspec/CPU2006/437.leslie3d/exe"
path2k6_namd="benchspec/CPU2006/444.namd/exe"
path2k6_dealII="benchspec/CPU2006/447.dealII/exe"
path2k6_soplex="benchspec/CPU2006/450.soplex/exe"
path2k6_povray="benchspec/CPU2006/453.povray/exe"
path2k6_calculix="benchspec/CPU2006/454.calculix/exe"
path2k6_GemsFDTD="benchspec/CPU2006/459.GemsFDTD/exe"
path2k6_tonto="benchspec/CPU2006/465.tonto/exe"
path2k6_lbm="benchspec/CPU2006/470.lbm/exe"
path2k6_wrf="benchspec/CPU2006/481.wrf/exe"
path2k6_sphinx3="benchspec/CPU2006/482.sphinx3/exe"

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

cd $BD/exec_spec2k6
source shrc
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="bwaves gamess milc zeusmp gromacs cactusADM leslie3d namd dealII  \
    soplex povray calculix GemsFDTD tonto lbm wrf sphinx3"
else
    blist=$SUB
fi
ML=`echo $COREML | awk -F "." '{print $2}'`
if [ "$ML" = "S32" -o "$ML" = "S64" -o "$ML" = "NS32" -o "$ML" = "NS64" ]; then
    ACTION="-a validate -i test"
else
    ACTION="-a validate"
fi
for b in $blist; do
    path=path2k6_$b
    bname=$b
    if [ "$b" = "sphinx3" ]; then bname=sphinx_livepretend; fi
    if [ "$b" = "xalancbmk" ]; then bname=Xalan; fi
    if [ -e $BD/exec_spec2k6/${!path}/${bname}_peak.tg ]; then
	sh -c "runspec -c spec_run.cfg $ACTION -e tg -n 1 $b > spec2k6_run.log 2>&1" >> spec2k6_run.log 2>&1
	v=`grep '^Success:' spec2k6_run.log`
	if [ "$v" != "" ]; then
	    l=`grep 'format: raw' spec2k6_run.log | awk '{print $4}'`
	    time=`cat $l | grep 'reported_time:' | awk '{tot=tot+$2; n=n+1} END {print tot/n}'`
	    echo "BMK=spec2k6.$b EXEC=Y TIME=$time" >> $TLOG
	    P="$P $b"
	else
	    echo "BMK=spec2k6.$b EXEC=N" >> $TLOG
	    F="$F $b"
	fi
    else
	echo "BMK=spec2k6.$b EXEC=N" >> $TLOG
	F="$F $b"
    fi
done

mkdir -p $BD/tmp_spec2k6fp
echo "$P" > $BD/tmp_spec2k6fp/spec2k6.pass
echo "$F" > $BD/tmp_spec2k6fp/spec2k6.fail
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
