#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_smalltests
if [ "$TGURU_C" = "" ]; then
    export TGURU_C=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
fi
export TGURU_LD=$HTOOLS/$TOOLS/bin/${PREFIX}gcc
export TGURU_FLAGS_C="$FLGS $T_CFLAGS"
export TGURU_FLAGS_LD="$FLGS $T_LFLAGS"

if [ "$SUB" = "all" ]; then
    blist="8q arg array bigframe BYTE_fp call1 call2 call3 call4 call5 cf copy fltconv \
	   gim incr init limits neg rel sort spill sr stdarg store struct2 struct switch wf1 yacc"
else
    blist=$SUB
fi

P=""
F=""
echo -n "" > smalltests_build.$MLTYPE.out
for base in $blist; do
    rm -f $base.exe $base.o
    echo "$TGURU_C $TGURU_FLAGS_C -o $base.exe $base.c -lm" >> smalltests_build.$MLTYPE.out 2>&1
    $TGURU_C $TGURU_FLAGS_C -c $base.c >> smalltests_build.$MLTYPE.out 2>&1
    $TGURU_LD $TGURU_FLAGS_LD -o $base.exe $base.o -lm >> smalltests_build.$MLTYPE.out 2>&1
    if [ -e $base.exe ]; then
	echo "BMK=smalltests.$base COMP=Y" >> $HLOG
	P="$P $base"
    else
	echo "BMK=smalltests.$base COMP=N" >> $HLOG
	F="$F $base";
    fi
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
