#!/bin/bash
# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_perfect
if [ "$TGURU_F" = "" ]; then
    export TGURU_F=$HTOOLS/$TOOLS/bin/${PREFIX}gfortran
fi
export TGURU_FLAGS_F="$FLGS $T_CFLAGS $T_LFLAGS"

if [ "$SUB" = "all" ]; then
    blist="adm arc2d dyfesm flo52 mdg mg3d qcd trfd"
else
    blist=$SUB
fi

P=""
F=""
echo -n "" > perfect_build.$MLTYPE.out

# this is fix for build issue from GCC 4.9.x onwards
x=`echo $TOOLS | grep "gcc-4.9.*\|gcc-4.10.*\|gcc-5.*"`
if [ "$x" != "" ];then
   NO_EXC_ERR="-ffpe-summary=none"
else
   NO_EXC_ERR=""
fi

# Those programs are outdated sources: bdna ocean spec77 spice track
for prog in $blist; do
    x=`echo $TGURU_F | grep gnuspe`
    if [ "$x" != "" ]; then
	# This is a hack because of e500v1/v2
	# The alternative is to remove this benchmark entirelly
	NO_VEC="-fno-tree-vectorize"
    else
	NO_VEC=""
    fi
    cd $prog
    rm -f $prog.exe
    [ -e $prog.f-ref ] && cp -f $prog.f-ref $prog.f
    echo "$TGURU_F $TGURU_FLAGS_F $NO_VEC $NO_EXC_ERR -o $prog.exe $prog.f ../TIMERS.f -lm" >> ../perfect_build.$MLTYPE.out 2>&1
    $TGURU_F $TGURU_FLAGS_F $NO_VEC $NO_EXC_ERR -o $prog.exe $prog.f ../TIMERS.f -lm >> ../perfect_build.$MLTYPE.out 2>&1
    if [ -e $prog.exe ]; then
	echo "BMK=perfect.$prog COMP=Y" >> $HLOG
	P="$P $prog"
    else
	echo "BMK=perfect.$prog COMP=N" >> $HLOG
	F="$F $prog"
    fi
    cd ../
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
