#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

cd $BD/tmp
P=""
F=""

if [ "$SUB" = "all" ]; then
    blist1="bezierv2fixed bezierv2float textv2 gs8"
    blist2="ditherv2 rotatev2"
else
    if [ "$SUB" = "ditherv2" -o "$SUB" = "rotatev2" ]; then
	blist1=""
	blist2=$SUB
    else
	blist1=$SUB
	blist2=""
    fi
fi
for e in $blist1; do
    for d in 2 3 4; do
	sh -c "./${e}_lite.exe -data${d} -do_uuencode > ${e}_d${d}_lite.log 2> ${e}_d${d}_lite.err" >> ${e}_d${d}_lite.err 2>&1
	let n=$?
	x=`cat ${e}_d${d}_lite.err`
	if [ $n = 0 -a "$x" = "" -o "${e}_d${d}" = "bezierv2float_d2" ]; then
	    echo "BMK=office-2.${e}_d${d} EXEC=Y" >> $TLOG
	    P="$P ${e}_d${d}_lite"
	else
	    echo "BMK=office-2.${e}_d${d} EXEC=N" >> $TLOG
	    F="$F ${e}_d${d}_lite"
	fi
    done
done
for e in $blist2; do
    for d in 2 3 4 5 6 7 8 9 10 11; do
	sh -c "./${e}_lite.exe -data${d} -do_uuencode > ${e}_d${d}_lite.log 2> ${e}_d${d}_lite.err" >> ${e}_d${d}_lite.err 2>&1
	let n=$?
	x=`cat ${e}_d${d}_lite.err`
	if [ $n = 0 -a "$x" = "" ]; then
	    echo "BMK=office-2.${e}_d${d} EXEC=Y" >> $TLOG
	    P="$P ${e}_d${d}_lite"
	else
	    echo "BMK=office-2.${e}_d${d} EXEC=N" >> $TLOG
	    F="$F ${e}_d${d}_lite"
	fi
    done
done
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
