#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
UniqueID=$4
SUB=$5
KEEP=$6

TLOG=$BD/${UniqueID}.target_log

cd $BD/tmp
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="ip_pktcheckb4m nat routelookup tcpmixed ip_pktcheckb1m \
           ip_pktcheckb512k ospfv2 tcpbulk ip_pktcheckb2m ip_reassembly qos tcpjumbo"
else
    blist=$SUB
fi
for e in $blist; do
    x=`grep 'Failure' ${e}_lite.log`
    y=`grep 'Iterations/Sec' ${e}_lite.log | awk '{print $4}'`
    if [ "$x" = "" ]; then
	echo "BMK=net-2.${e} VAL=Y ITER=$y" >> $TLOG
	P="$P ${e}_lite"
    else
	echo "BMK=net-2.${e} VAL=N" >> $TLOG
	F="$F ${e}_lite"
    fi
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
[ "$KEEP" != "Y" ] && rm -rf $BD/tmp
