#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6
SIM=$7
[ "$SIM" = "none" ] && SIM=""

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

cd $BD/tmp
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="ip_pktcheckb4m nat routelookup tcpmixed ip_pktcheckb1m \
           ip_pktcheckb512k ospfv2 tcpbulk ip_pktcheckb2m ip_reassembly qos tcpjumbo"
else
    blist=$SUB
fi
for e in $blist; do
    sh -c "$SIM ./${e}_lite.exe > ${e}_lite.log 2> ${e}_lite.err" >> ${e}_lite.err 2>&1
    let n=$?
    x=`cat ${e}_lite.err`
    if [ $n = 0 -a "$x" = "" ]; then
	echo "BMK=net-2.${e} EXEC=Y" >> $TLOG
	P="$P ${e}_lite"
    else
	echo "BMK=net-2.${e} EXEC=N" >> $TLOG
	F="$F ${e}_lite"
    fi
done
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
