#!/bin/bash

# Arguments are the following
bd=$1
target=$2
user=$3
rep=$4

cd $bd/installed_eembc/networking-2.0/networking/gcc/bin_lite

blist="ip_pktcheckb1m ip_pktcheckb2m ip_pktcheckb4m ip_pktcheckb512k \
       ospfv2 qos routelookup ip_reassembly ip_reassembly2 nat nat2"

for b in $blist; do
    if [ "$b" = "ip_reassembly2" ]; then 
	e=ip_reassembly
	sp="-INITTIME"
    elif [ "$b" = "nat2" ]; then
	e=nat
	sp="-INITTIME"
    else
	e=$b
	sp=""
    fi
    rm -f ${e}_lite.err ${e}_lite.log
    scp -q ${e}_lite.exe $user@$target:/tmp
    for (( i=0 ; i<$rep ; i++ )) ; do
	ssh -l $user $target /tmp/${e}_lite.exe $sp >> ${e}_lite.log 2>> ${e}_lite.err
    done
    let n=$?
    x=`cat ${e}_lite.err`
    if [ $n = 0 -a "$x" = "" ]; then
	x=`grep 'Failure' ${e}_lite.log`
	y=`grep 'Iterations/Sec' ${e}_lite.log`
	if [ "$x" = "" -a "$y" != "" ]; then
	    grep 'Iterations/Sec' ${e}_lite.log | awk '{print $4}'
	    # Complete any missing value with zeroes
	    nr=`grep 'Iterations/Sec' ${e}_lite.log | wc -l `
            for (( i=$nr ; i<$rep ; i++ )); do
		echo 0
            done
	else
            for (( i=0 ; i<$rep ; i++ )); do
		echo 0
            done
	fi
    else
        for (( i=0 ; i<$rep ; i++ )); do
            echo 0
        done
    fi
done
