#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6
SIM=$7
[ "$SIM" = "none" ] && SIM=""

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

if [ "$SUB" = "all" ]; then
    blist="applu appsp buk cgm embar fftpde"
else
    blist=$SUB
fi

cd $BD/tmp_nas
P=""
F=""
for prog in $blist; do
    rm -f $prog.output
    [ -e $prog.inp-ref ] && cp -f $prog.inp-ref $prog.input
    sh -c "$SIM ./$prog.exe > $prog.output 2> $prog.err" >> $prog.err 2>&1
    let n=$?
    x=`cat $prog.err`
    if [ $n -eq 0 -a "$x" = "" ]; then
	echo "BMK=nas.$prog EXEC=Y" >> $TLOG
        P="$P $prog"
    else
	echo "BMK=nas.$prog EXEC=N" >> $TLOG
        F="$F $prog"
    fi
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
