#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh

cd $BD/installed_nas/src
if [ "$TGURU_F" = "" ]; then
    export TGURU_F=$HTOOLS/$TOOLS/bin/${PREFIX}gfortran
fi
export TGURU_FLAGS_F="$FLGS $T_CFLAGS $T_LFLAGS"

if [ "$SUB" = "all" ]; then
    blist="applu appsp buk cgm embar fftpde"
else
    blist=$SUB
fi

P=""
F=""
echo -n "" > nas_build.$MLTYPE.out
# Removed because they are not stable: appbt mgrid
for prog in $blist; do
    cd $prog
    rm -f $prog.exe
    [ -e $prog.f-ref ] && cp -f $prog.f-ref $prog.f
    echo "$TGURU_F $TGURU_FLAGS_F -o $prog.exe $prog.f -lm" >> ../nas_build.$MLTYPE.out 2>&1
    $TGURU_F $TGURU_FLAGS_F -o $prog.exe $prog.f -lm >> ../nas_build.$MLTYPE.out 2>&1
    if [ -e $prog.exe ]; then
	echo "BMK=nas.$prog COMP=Y" >> $HLOG
	P="$P $prog"
    else
	echo "BMK=nas.$prog COMP=N" >> $HLOG
	F="$F $prog"
    fi
    cd ../
done

nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
