#!/bin/bash

# Arguments are the following
BD=$1
TU=$2
TN=$3
UniqueID=$4
SUB=$5
KEEP=$6

TLOG=$BD/${UniqueID}.target_log
if [ "$SUB" = "all" ]; then
    blist="gmp mpfr mpc ppl cloog"
else
    blist=$SUB
fi

let nP=0
let nF=0
cd $BD/tmp
for lt in $blist; do
    case $lt in
	gmp)
	    let nP=$nP+`grep '^PASS' gmp-5.0.5.test | wc -l`
	    let nF=$nF+`grep '^FAIL' gmp-5.0.5.test | wc -l`
	    ;;
	mpfr)
	    let nP=$nP+`grep '^PASS' mpfr-3.1.1.test | wc -l`
	    let nF=$nF+`grep '^FAIL' mpfr-3.1.1.test | wc -l`
	    ;;
	mpc)
	    let nP=$nP+`grep '^PASS' mpc-1.0.test | wc -l`
	    let nF=$nF+`grep '^FAIL' mpc-1.0.test | wc -l`
	    ;;
	ppl)
	    let nP=$nP+`grep '^PASS' ppl-0.12.1.test | wc -l`
	    let nF=$nF+`grep '^FAIL' ppl-0.12.1.test | wc -l`
	    ;;
	cloog)
	    let nP=$nP+`grep '^PASS' cloog-0.16.3.test | wc -l`
	    let nF=$nF+`grep '^FAIL' cloog-0.16.3.test | wc -l`
	    ;;
	eglibc)
	    grep Error eglibc-2.15.test
	    ;;
    esac
done
echo "..PASS $nP FAIL $nF"
[ "$KEEP" != "Y" ] && rm -rf $BD/tmp
