#!/bin/bash

# Arguments are the following
MLTYPE=$1
BD=$2
HTOOLS=$3
TLIBS=$4
TOOLS=$5
PREFIX=$6
UniqueID=$7
SUB=$8
FLGS="$9"

HLOG=$BD/${UniqueID}.host_log

source $BD/f-test/set_flags.sh
source $BD/f-test/linuxtst.env
if [ "$SUB" = "all" ]; then
    blist="gmp mpfr mpc ppl cloog"
else
    blist=$SUB
fi

mkdir -p $BD/tmp
cd $BD/tmp
let nP=0
let nF=0
for lt in $blist; do
    LT_FLG=""
    case $lt in
	gmp)
	    tar xjf $BD/installed_linuxtst/gmp-5.0.5.tar.bz2
	    pkg_cb gmp-5.0.5 "" \
		"CPPFLAGS=-fexceptions CC=\"$HTOOLS/$TOOLS/bin/${PREFIX}gcc -isystem $HTOOLS/$TOOLS $FLGS $T_CFLAGS\" CXX=\"$HTOOLS/$TOOLS/bin/${PREFIX}g++ -isystem $HTOOLS/$TOOLS $FLGS $T_CFLAGS\" LDFLAGS=\"$T_LFLAGS $T_CFLAGS\" ABI=$T_ABI" \
		"--prefix=/usr --enable-cxx --enable-mpbsd"
	    ;;
	mpfr)
	    tar xJf $BD/installed_linuxtst/mpfr-3.1.1.tar.xz
	    pkg_cb mpfr-3.1.1 "" \
		"CC=\"$HTOOLS/$TOOLS/bin/${PREFIX}gcc -isystem $HTOOLS/$TOOLS $FLGS $T_CFLAGS\" CXX=\"$HTOOLS/$TOOLS/bin/${PREFIX}g++ -isystem $HTOOLS/$TOOLS $FLGS $T_CFLAGS\" LDFLAGS=\"$T_LFLAGS $T_CFLAGS\"" \
		"--prefix=/usr --host=$T_HOST --enable-shared"
	    ;;
	mpc)
	    tar xzf $BD/installed_linuxtst/mpc-1.0.tar.gz
	    pkg_cb mpc-1.0 "" \
		"CC=\"$HTOOLS/$TOOLS/bin/${PREFIX}gcc -isystem $HTOOLS/$TOOLS $FLGS $T_CFLAGS\" LDFLAGS=\"$T_LFLAGS $T_CFLAGS\" EGREP=\"grep -E\"" \
		"--prefix=/usr --host=$T_HOST"
	    ;;
	ppl)
	    tar xjf $BD/installed_linuxtst/ppl-0.12.1.tar.bz2
	    pkg_cb ppl-0.12.1 "" \
		"CPPFLAGS=-fexceptions CC=\"$HTOOLS/$TOOLS/bin/${PREFIX}gcc -isystem $HTOOLS/$TOOLS $FLGS $T_CFLAGS\" CXX=\"$HTOOLS/$TOOLS/bin/${PREFIX}g++ -isystem $HTOOLS/$TOOLS $FLGS $T_CFLAGS\" LDFLAGS=\"$T_LFLAGS $T_CFLAGS\"" \
		"--prefix=/usr --host=$T_HOST --enable-shared"
	    ;;
	cloog)
	    tar xzf $BD/installed_linuxtst/cloog-0.16.3.tar.gz
	    pkg_cb cloog-0.16.3 "" \
		"CC=\"$HTOOLS/$TOOLS/bin/${PREFIX}gcc -isystem $HTOOLS/$TOOLS $FLGS $T_CFLAGS\" LDFLAGS=\"$T_LFLAGS $T_CFLAGS\"" \
		"--prefix=/usr --host=$T_HOST --enable-shared"
	    ;;
	eglibc)
	    tar xjf $BD/installed_linuxtst/eglibc-2.15-r17386.tar.bz2
	    cd  eglibc-2.15
	    patch -p1 -s < $BD/installed_linuxtst/eglibc-2.15-fixes-1.patch
	    patch -p1 -s < $BD/installed_linuxtst/eglibc-2.15-fix_prolog-sched-gcc47
	    patch -p1 -s < $BD/installed_linuxtst/eglibc-2.15-readv_proto
	    sed -i -n 's/\(&& $name ne\) "db1"/ & \1 "nss_test1"/' scripts/test-installation.pl
	    sed -i -n "s|libs -o|libs $T_LFLAGS -o|" scripts/test-installation.pl
	    sed -i "s/\(^check-textrel-CFLAGS = \)/\1 -m32 /" elf/Makefile
	    sleep 20
	    cd ../
	    pkg_config eglibc-2.15 "eglibc-2.15_obj" "" \
		"CC=\"$HTOOLS/$TOOLS/bin/${PREFIX}gcc $FLGS $T_CFLAGS\" CXX=\"$HTOOLS/$TOOLS/bin/${PREFIX}g++ $FLGS $T_CFLAGS\"" \
		"--prefix=/usr --disable-profile --enable-add-ons --enable-kernel=2.6.32 --libexecdir=/usr/lib/eglibc --host=$T_HOST"
	    pkg_make eglibc-2.15 "eglibc-2.15_obj" make "" "$NJOBS"
	    ;;
    esac
    if [ "$LT_FLG" = "" ]; then
	echo "BMK=linuxtst.$lt COMP=Y" >> $HLOG
	let nP=$nP+1
    else
	echo "BMK=linuxtst.$lt COMP=N" >> $HLOG
	let nF=$nF+1
    fi
done
echo "..PASS $nP FAIL $nF"
