#!/bin/bash

# Arguments are the following
COREML=$1
BD=$2
TU=$3
TN=$4
UniqueID=$5
SUB=$6

TLOG=$BD/${UniqueID}.target_log
echo "CORE=$COREML" >> $TLOG

cd $BD/tmp
P=""
F=""
if [ "$SUB" = "all" ]; then
    blist="a2time01 aifftr01 aifirf01 aiifft01 basefp01 bitmnp01 cacheb01 canrdr01 \
           idctrn01 iirflt01 pntrch01 puwmod01 rspeed01 tblook01 ttsprk01"
else
    blist=$SUB
fi
for e in $blist; do
    sh -c "./${e}.exe -autogo > ${e}.log 2> ${e}.err" >> ${e}.err 2>&1
    let n=$?
    x=`cat ${e}.err`
    if [ $n = 0 -a "$x" = "" -o "$e" = "ttsprk01" ]; then
	echo "BMK=auto-1.$e EXEC=Y" >> $TLOG
	P="$P $e"
    else
	echo "BMK=auto-1.$e EXEC=N" >> $TLOG
	F="$F $e"
    fi
    # The ttsprk01 is known to fail. Accept any result from it
    sh -c "./${e}_lite.exe > ${e}_lite.log 2> ${e}_lite.err" >> ${e}_lite.err 2>&1
    let n=$?
    x=`cat ${e}_lite.err`
    if [ $n = 0 -a "$x" = "" -o "$e" = "ttsprk01" ]; then
	echo "BMK=auto-1.${e}_lite EXEC=Y" >> $TLOG
	P="$P ${e}_lite"
    else
	echo "BMK=auto-1.${e}_lite EXEC=N" >> $TLOG
	F="$F ${e}_lite"
    fi
done
nP=0
nF=0
for n in $P; do
    let nP=$nP+1
done
for n in $F; do
    let nF=$nF+1
done
echo "..PASS $nP FAIL $nF"
