#!/bin/bash

# This little script is useful to measure performance of ssh connections.
# They are important for fast dejagnu execution

# What to expect:
# Some collected numbers
#
#       F17  F18  F19   F6   F9  F10   B1   B4   B8  B12
# F17   .15  .32
# F18   .35  .15
# F19   .39  .34
# F6    .36  .33
# F9    .14  .14
# F10   .50  .50
# B1    .13  .15
# B4    .72  .70
# B8    .16  .13
# B12   .15  .18
#
# With 3 simultaneous loads
# F10  1.02
# B8   0.13
#
# Disabling PAM GSSAPI
# F10   .26
# ..and 3 simultaneous loads
# F10   .20

let loops=10
for m in $@; do
    t1=`date +%s`
    for (( f=0; f<$loops; f=$f+1 )); do
	for g in 0 1 2 3 4 5 6 7 8 9; do 
	    ssh $m echo $f-$g >/dev/null
	done
    done
    t2=`date +%s`
    echo -ne "$m\t"
    echo $t1 $t2 | awk '{print "tot",($2-$1),"avg",($2-$1)/100}'
done
