#!/bin/bash

VALscript=`readlink -e $0`
VALdir=`dirname $VALscript`

# Arguments of this script
SRC=$1
shift
WD="$*"

if [ "$SRC" = "" -o "$WD" = "" ]; then
    echo "Usage: val_release_deja.sh <source fragment> <list of release directories>"
    echo "ex:  val_release_deja.sh F494 WD_release_gc53125c_build_Fed_ELe200_ML*"
    exit 1
fi

for wdir in $WD; do
    manifest=""
    tgt=`echo $wdir | awk -F "_" '{print $6}'`
    ln_first=903
    ln_incr=3

    case $tgt in
	Earmv7)
	    # ref: armv6-m armv7-m
	    manifest=${SRC}-Earmv7.xfail
	    ln_first=903
	    ln_incr=3
	    ;;
	Earmv8)
	    # ref: armv8-a
	    manifest=${SRC}-Earmv8.xfail
	    ln_first=903
	    ln_incr=3
	    ;;
	Xarmv8)
	    # ref: armv8-a
	    manifest=${SRC}-Xarmv8.xfail
	    ln_first=905
	    ln_incr=5
	    ;;
	ELe200)
	    # ref: e200
	    manifest=${SRC}-eabivle.xfail
	    ln_first=903
	    ln_incr=3
	    ;;
	ELe200SD)
	    # ref: e200
	    manifest=${SRC}-eabivleSD.xfail
	    ln_first=903
	    ln_incr=3
	    ;;
	ELe6500 | ELe5500 | ELe500mc | ELe300c3 | ELe300c2)
	    # ref: e300c3
	    manifest=${SRC}-eabi.xfail
	    ln_first=903
	    ln_incr=3
	    ;;
	ELe500v2)
	    # ref: e500v2
	    manifest=${SRC}-eabispe.xfail
	    ln_first=903
	    ln_incr=3
	    ;;
	ELe600)
	    # ref: e600
	    manifest=${SRC}-eabialtivec.xfail
	    ln_first=903
	    ln_incr=3
	    ;;
	XLMe6500 | XLMe5500 | XLMe500mc | XLMe300c3 | XLe300c2)
	    # ref: e6500
	    manifest=${SRC}-linux.xfail
	    ln_first=905
	    ln_incr=5
	    ;;
	XLMe500v2)
	    # ref: e500v2
	    manifest=${SRC}-linuxspe.xfail
	    ln_first=905
	    ln_incr=5
	    ;;
	XLMe600)
	    # ref: e600
	    manifest=${SRC}-linuxaltivec.xfail
	    ln_first=905
	    ln_incr=5
	    ;;
	*)
	    echo "Invalid target: $tgt"
	    echo "Usage: val_release_deja.sh <source fragment> <list of release directories>"
	    echo "ex:  val_release_deja.sh F494 WD_release_gc53125c_build_Fed_ELe200_ML*"
	    exit 1
	    ;;
    esac

    let ln=$ln_first
    cd $wdir
    for m in 0 1 2 3 4 5 6; do
	if [ -f build.${ln}.gcc.sum ]; then
	    echo -e "###     $tgt \tML=$m"
	    echo ""
	    if [ -f build.${ln}.gfortran.sum ]; then
		$VALdir/validate_failures.py --results="build.${ln}.gcc.sum build.${ln}.g++.sum build.${ln}.gfortran.sum" \
					     --manifest=$VALdir/$manifest
	    else
		$VALdir/validate_failures.py --results="build.${ln}.gcc.sum build.${ln}.g++.sum" \
					     --manifest=$VALdir/$manifest
	    fi
	    let ln=$ln+$ln_incr
	fi
    done
    cd ../
done
