#!/bin/bash

VALscript=`readlink -e $0`
VALdir=`dirname $VALscript`

# Arguments of this script
ver=$1
type=$2

if [ "$ver" = "" -o "$type" = "" ]; then
    echo "Usage val_deja_logs.sh <source version> <target type: Evle, E, Espe, Ealt, L, Lspe, Lalt>"
    exit 1
fi
manifest=""
case $type in
    Evle)
	# ref: e200
	manifest=${ver}-eabivle.xfail
	;;
    E)
	# ref: e300c3
	manifest=${ver}-eabi.xfail
	;;
    Espe)
	# ref: e500v2
	manifest=${ver}-eabispe.xfail
	;;
    Ealt)
	# ref: e600
	manifest=${ver}-eabialtivec.xfail
	;;
    L)
	# ref: e6500
	manifest=${ver}-linux.xfail
	;;
    Lspe)
	# ref: e500v2
	manifest=${ver}-linuxspe.xfail
	;;
    Lalt)
	# ref: e600
	manifest=${ver}-linuxaltivec.xfail
	;;
    *)
	echo "Usage val_deja_logs.sh <source version> <target type: Evle, E, Espe, Ealt, L, Lspe, Lalt>"
	exit 1
	;;
esac

for m in 0 1 2 3; do
    if [ -f ML${m}-gcc.sum ]; then
	echo "###"
	if [ -f ML${m}-gfortran.sum ]; then
	    $VALdir/validate_failures.py --results="ML${m}-gcc.sum ML${m}-g++.sum ML${m}-gfortran.sum" \
					 --manifest=$VALdir/$manifest
	else
	    $VALdir/validate_failures.py --results="ML${m}-gcc.sum ML${m}-g++.sum" \
					 --manifest=$VALdir/$manifest
	fi
    fi
done
