#!/bin/bash

# There are some descriptors for building Codesourcey, That is enough to get a successful build:
# build.sh s=CS-2011.03-38 CS-linux
#
# But, to make the result as much as possible equivalent to the original one
# (namely using build.sh option -I), some tricks has to be used.
# There will be some "No such file or directory" errors that can be ignored
#
# The result will have those differences to the original:
# - We cannot use "Use this url to file a bug, etc.." message when gcc crashes
# - We do not build gdb
# - We do not have "installanywhere" wrapper
# - The binaries are linked to "contemporary" glibc libraries.
#     these binaries will not work if installed on CDE (linux-2.6.18). (The original CS drops do) 
# - Both the eabi and elf tools do not have libcs3 (proprietary Codesourcery) and thus do not support -msim
#
# Here is the recipe:

# Step 0 - To create 32 bits binaries (perf3farm19)

export PATHORIG=/local/build_support/i686-linux/bin:$PATH
export REPD=/proj/ppc/DT/labhome/edmar/build_repo/releases

# Step 1 - Build linux tools

export PATH=$PATHORIG
# Build the linux host tools only
build.sh s=CS-2011.03-38 CS-linux -I -i /opt/freescale -s "chk dst rm src intgr gmp mpfr mpc ppl cloog Xbin Tbin gccMl lhdr ghdr gccSl glibc Xgccl Xloc Gloc"
# Save it in a tarball
build.sh s=CS-2011.03-38 CS-linux -I -s tar
# Save what was just built, and put it in the PATH
cp -rf freescale-2011.03 save-freescale-2011.03
export PATH=`pwd`/save-freescale-2011.03/bin:$PATHORIG
# Build the ming32 host tools
build.sh s=CS-2011.03-38 CS-linux -I -s "Wsetup Wiconv Wgtext Wgmp Wmpfr Wmpc Wppl Wcloog Wbin Wgcc"
# Save it in a tarball
build.sh s=CS-2011.03-38 CS-linux -I -s Wtar
# To avoid nanming conflicting with the nexts steps, rename tarballs
for p in $REPD/freescale-2011.03-i686-linux-*; do
    f=`basename $p`
    mv -f $REPD/$f $REPD/CS-linux-$f
done
for p in $REPD/freescale-2011.03-i686-mingw32-*; do
    f=`basename $p`
    mv -f $REPD/$f $REPD/CS-linux-$f
done
rm -rf freescale-2011.03 save-freescale-2011.03

# Step 2 - Build eabi tools

export PATH=$PATHORIG
# Build the linux host tools only
build.sh s=CS-2011.03-39 CS-eabi -I -i /opt/freescale -s "chk dst rm src intgr gmp mpfr mpc ppl cloog Ebin Tbin EgccMl newlib Egccl"
# Save it in a tarball
build.sh s=CS-2011.03-39 CS-eabi -I -s tar
# Save what was just built, and put it in the PATH
cp -rf freescale-2011.03 save-freescale-2011.03
export PATH=`pwd`/save-freescale-2011.03/bin:$PATHORIG
# Build the ming32 host tools
build.sh s=CS-2011.03-39 CS-eabi -I -s "Wsetup Wiconv Wgtext Wgmp Wmpfr Wmpc Wppl Wcloog WEbin WEgcc"
# Save it in a tarball
build.sh s=CS-2011.03-39 CS-eabi -I -s Wtar
# To avoid nanming conflicting with the nexts steps, rename tarballs
for p in $REPD/freescale-2011.03-i686-linux-*; do
    f=`basename $p`
    mv -f $REPD/$f $REPD/CS-eabi-$f
done
for p in $REPD/freescale-2011.03-i686-mingw32-*; do
    f=`basename $p`
    mv -f $REPD/$f $REPD/CS-eabi-$f
done
rm -rf freescale-2011.03 save-freescale-2011.03

# Step 3 - Build elf tools

export PATH=$PATHORIG
# Build the linux host tools only
build.sh s=CS-2011.03-40 CS-elf -I -i /opt/freescale -s "chk dst rm src intgr gmp mpfr mpc ppl cloog Ebin Tbin EgccMl newlib Egccl"
# Save it in a tarball
build.sh s=CS-2011.03-40 CS-elf -I -s tar
# Save what was just built, and put it in the PATH
cp -rf freescale-2011.03 save-freescale-2011.03
export PATH=`pwd`/save-freescale-2011.03/bin:$PATHORIG
# Build the ming32 host tools
build.sh s=CS-2011.03-40 CS-elf -I -s "Wsetup Wiconv Wgtext Wgmp Wmpfr Wmpc Wppl Wcloog WEbin WEgcc"
# Save it in a tarball
build.sh s=CS-2011.03-40 CS-elf -I -s Wtar
# To avoid nanming conflicting with the nexts steps, rename tarballs
for p in $REPD/freescale-2011.03-i686-linux-*; do
    f=`basename $p`
    mv -f $REPD/$f $REPD/CS-elf-$f
done
for p in $REPD/freescale-2011.03-i686-mingw32-*; do
    f=`basename $p`
    mv -f $REPD/$f $REPD/CS-elf-$f
done
rm -rf freescale-2011.03 save-freescale-2011.03

# Another CS linux release

export PATHORIG=/local/build_support/i686-linux/bin:$PATH
export REPD=/proj/ppc/DT/labhome/edmar/build_repo/releases
export PATH=$PATHORIG
build.sh s=CS-2010.09-55 CS-linux -I -i /opt/freescale -s "chk dst rm src intgr gmp mpfr mpc ppl cloog Xbin Tbin gccMl lhdr ghdr gccSl glibc Xgccl Xloc Gloc"
build.sh s=CS-2010.09-55 CS-linux -I -s tar
cp -rf freescale-2010.09 save-freescale-2010.09
export PATH=`pwd`/save-freescale-2010.09/bin:$PATHORIG
build.sh s=CS-2010.09-55 CS-linux -I -s "Wsetup Wiconv Wgtext Wgmp Wmpfr Wmpc Wppl Wcloog Wbin Wgcc"
build.sh s=CS-2010.09-55 CS-linux -I -s Wtar
for p in $REPD/freescale-2010.09-i686-linux-*; do
    f=`basename $p`
    mv -f $REPD/$f $REPD/CS-linux-$f
done
for p in $REPD/freescale-2010.09-i686-mingw32-*; do
    f=`basename $p`
    mv -f $REPD/$f $REPD/CS-linux-$f
done
rm -rf freescale-2010.09 save-freescale-2010.09

