#!/bin/bash

USR=`id -nu`
GCCSUFFIX=""

for a in "$@"; do
    case $a in
	-h)
	    cat <<EOF
Usage is:
    check_sanity.sh r={comp|run|rem} [t=<target>] [u=<user>] g=<gcc/g++ prefix> exe

Where arguments are:
    -h          Print this help and exit
    r=<type>    Compile only, Execute, Execute remotely
    t=<target>  For remote connections, name of the machine to ssh to
    u=<user>    For remote connections
    o=<options> Extra compiler options. Ex: -msim, --sysroot=<>
    exe         Add ".exe" suffix for binaries
EOF
	    exit 0
	    ;;
	r=*)
	    RUN=${a:2}
	    ;;
        g=*)
	    GCCPREFIX=${a:2}
	    ;;
	o=*)
	    EXTOPTS="${a:2}"
	    ;;
	t=*)
	    TGT=${a:2}
	    ;;
	u=*)
	    USR=${a:2}
	    ;;
	exe)
	    GCCSUFFIX=".exe"
	    ;;
	*)
	    echo "Unkonwn options: $a"
	    exit 1
	    ;;
    esac
done

GCC=${GCCPREFIX}gcc${GCCSUFFIX}
GPP=${GCCPREFIX}g++${GCCSUFFIX}

A0=("$GCC tst.c" "$GPP tst.cxx")
nA0=("C    " "C++  ")
A1=("" "-static")
nA1=("Dynamic  " "Static   ")
A2=("" "-m32" "-m64" "-msoft-float")
nA2=("default  " "m32      " "m64      " "nof      ")

cat > tst.c <<EOF
#include <stdio.h>
int
main (int argc, char **argv)
{
  printf ("Hello World %d\n", argc);
}
EOF
cat > tst.cxx <<EOF
#include <iostream>
#include <stdlib.h>

class foo {
public:
  foo ();
  int magic_const;
};

foo::foo () {
  magic_const = 0xdeadbeef;
}

foo i_of_foo;

int
main (int argc, char **argv)
{
  if (i_of_foo.magic_const != 0xdeadbeef)
    abort();
  std::cout << "Hello World " << argc << std::endl;
}
EOF
cat > tst.ref <<EOF
Hello World 1
EOF

let T=0

try () {
    echo "$1 -Werror -O2 -o tst-$T.exe $2" > tst-$T.cmd
    $1 -Werror -O2 -o tst-$T.exe $2 -v > tst-$T.gcc 2>&1
    x=$?
    if [ "$RUN" != "run" -a "$RUN" != "rem" ]; then
	if [ $x != 0 ]; then echo "..FAIL"; else echo "..OK"; fi
    elif [ "$RUN" = "rem" ]; then
	if [ $x != 0 ]; then echo "..FAIL"; return; else echo -n "..C"; fi
	scp tst-$T.exe $USR@$TGT:/tmp > tst-$T.scp 2>&1
	ssh -l $USR $TGT /tmp/tst-$T.exe > tst-$T.out 2>&1
	x=`diff tst-$T.out tst.ref`
	if [ "$x" != "" ]; then echo "..FAIL"; return; else echo "..R"; fi    
	ssh -l $USR $TGT rm -f /tmp/tst-$T.exe	
    else
	if [ $x != 0 ]; then echo "..FAIL"; return; else echo -n "..C"; fi
	./tst-$T.exe > tst-$T.out 2>&1
	x=`diff tst-$T.out tst.ref`
	if [ "$x" != "" ]; then echo "..FAIL"; return; else echo "..R"; fi    
    fi
}

for ((i0=0; i0<${#A0[@]}; i0++)); do
    c="${A0[$i0]}"
    for ((i1=0; i1<${#A1[@]}; i1++)); do
	f1="${A1[$i1]}"
	for ((i2=0; i2<${#A2[@]}; i2++)); do
	    f2="${A2[$i2]}"
	    printf "%2d %s" $T "${nA0[$i0]}${nA1[$i1]}${nA2[$i2]}"
	    try "$c" "$EXTOPTS $f1 $f2"
	    let T=$T+1
	done
    done
done

# Add test case to verify Graphite
cat > tst.c <<EOF
EOF
cat > tst.cxx <<EOF
EOF

for ((i0=0; i0<${#A0[@]}; i0++)); do
    c="${A0[$i0]}"
    echo -n "Testing Graphite for ${nA0[$i0]}"
    x=`$c -Werror -O2 -c -floop-block`
    if [ "$x" != "" ]; then echo "..FAIL"; else echo "..Ok"; fi
done
